//RGB Colour Clock Driver alpha 1.1

//Written by Christoph Kreis
//You can change the code if you like or share it with your friends, but it's not allowed to deal with the code.

#define F_CPU 16000000 // 16 Mhz

#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h> 
#include <util/delay.h>
#include <util/twi.h>
#include <avr/eeprom.h>

#define UART_BAUD_RATE 9600
#define UART_BAUD_CALC(UART_BAUD_RATE,F_CPU) ((F_CPU)/((UART_BAUD_RATE)*16l)-1)

#define  LDAC0			PD6
#define  PWM	 		PD3

#define  RGB_RED_ON		PORTD |= _BV(PD2)     
#define  RGB_BLUE_ON		PORTD |= _BV(PD1)
#define  RGB_GREEN_ON		PORTD |= _BV(PD0)
#define  SOUND_OFF		PORTD |= _BV(PD5)

#define  RGB_RED_OFF		PORTD &= ~ _BV(PD2)
#define  RGB_BLUE_OFF		PORTD &= ~ _BV(PD1)
#define  RGB_GREEN_OFF		PORTD &= ~ _BV(PD0)
#define  SOUND_ON		PORTD &= ~ _BV(PD5)

// MPC LDAC0T
/*
 * The LDAC (latch DAC synchronization input) pin is
 * used to transfer the input latch register to the DAC reg-
 * ister (output latches, VOUT). When this pin is low, VOUT
 * is updated with input register content. This pin can be
 * tied to low (VSS) if the VOUT update is desired at the
 * rising edge of the CS pin. This pin can be driven by an
 * external control device such as an MCU I/O pin.
 */

#define DisLoad_MPC     PORTD |=  (1 << LDAC0)
#define EnLoad_MPC      PORTD &=~ (1 << LDAC0)


// SPI Konfig
#define MOSI			PB3
#define MISO			PB4
#define SCK	            PB5

#define LOAD  			PB0

#define  SELECT0_MPC    	PB0
#define  SELECT1_MPC		PB1
#define  SELECT2_SR         PD7

#define SNOOZE_TIME            10
#define TIMEOUTCOUNTER_SNOOZE 100
#define TIMEOUTCOUNTER  254
#define LIGHT_TRIGGER  55

#define ADDRESS_DIGITS_BIG    100
#define ADDRESS_DIGITS_SMALL  172
#define ADDRESS_DIGITS_ABC    202



//shift Register Setting
#define EnLoad    PORTD &=~ (1 << SELECT2_SR)
#define DisLoad   PORTD |=  (1 << SELECT2_SR)

#define sr_clear_low    PORTD &=~ (1 << PD4)
#define sr_clear_high   PORTD |=  (1 << PD4)




volatile uint8_t t_zsec=0;
volatile uint8_t t_sec=30;
volatile uint8_t t_min=0;
volatile uint8_t t_std=11;
volatile uint8_t hour12std=0;
volatile uint8_t BCD_2Digit=0;

volatile uint8_t led_sec=0;
volatile uint8_t led_min=15;
volatile uint8_t led_std=6;

volatile uint8_t  day=1;
volatile uint8_t  month=1;
volatile uint8_t  year=15;

volatile uint8_t sensor_set=0b00000000;
// sensor_set(1 << 0) = dim     0 = off 	1 = dim
// sensor_set(1 << 1) = wake    0 = off 	1 = wake


volatile uint8_t ring_set=1;	// 0 = single , 1 = multi , 2 = mixed
volatile uint8_t screen=2;
volatile uint8_t RGBM_Bright[4]={5,5,5,5};
volatile uint8_t rgb_dim_level[4]={150,150,150,10};

volatile uint8_t alarm_min[7]={1,2,3,4,5,6,7};
volatile uint8_t alarm_std[7]={1,2,3,4,5,6,7};

volatile uint8_t final_alarm_std=0;
volatile uint8_t final_alarm_min=0;

volatile uint8_t alarm_nr = 0;
volatile uint8_t alarm_status=0b00100100;
// alarm_status(1 << 0) = alarm ready on/off     		0 = off		1 = on
// alarm_status(1 << 1) = alarm start/stop (glow)       0 = off		1 = on
// alarm_status(1 << 2) = Light Diode get up            0 = off		1 = on
// alarm_status(1 << 3) = show snooze			        0 = off		1 = show
// alarm_status(1 << 5) = glow (alarm)                  0 = off     1 = on (activ)
// alarm_status(1 << 6) = glow RGB LEDS (when alarming) 0 = off     1 = on
// alarm_status(1 << 7) = glow RGB LEDS (before alarm)  0 = off     1 = on

volatile uint8_t TIMEOUT=0;
volatile uint8_t SKIP=0;

volatile uint16_t row_bits=0b1000000000000000;
volatile uint16_t matrix[14];// enthält die Bildinformationen
volatile uint8_t  rgb_led[14]={0,0,0,0,0,0,0,0,0,0,0,0,0,0};

volatile uint8_t  status_button=0b00000000;

volatile uint8_t  status_byte_clock=0b00010000;
// status_byte_clock(1 << 0) = alarm ring               0 = off           1 = on
// status_byte_clock(1 << 1) = beep_beep_set            0 = off           1 = on
// status_byte_clock(1 << 2) = second on/off            0 = off           1 = on  
// status_byte_clock(1 << 3) = RTC DS 1307              0 = connected     1 = off (disconnected)
// status_byte_clock(1 << 4) = prepare matrix display   0 = not prepare   1 =prepare
// status_byte_clock(1 << 5) = 12/24 modus              0 = 24 mod        1 = 12 mod
// status_byte_clock(1 << 6) = setup menu               0 = leave setup   1 = enter (loop) setup  
// status_byte_clock(1 << 7) = Timout                   0 = off           1 = on

volatile uint8_t  status_byte_time=0b01000111;
// status_byte_time(1 << 0) = sec change            	0= not changed    1=changed
// status_byte_time(1 << 1) = min change                0= not changed    1=changed
// status_byte_time(1 << 2) = std change                0= not changed    1=changed
// status_byte_time(1 << 3) = date change               0= not changed    1=changed
// status_byte_time(1 << 4) = black out status          0= clock not set  1=clock ist set  
// status_byte_time(1 << 5) = alarm sound off help bit
// status_byte_time(1 << 6) = alarm status change       0= not changed    1=changed
// status_byte_time(1 << 7) = 


// Eigene Libs einbinden
#include "_display_LIFO.h"
#include "_eeprom_atmega328p.h"
#include "_I2C_RTC.h"
#include "_clock_tools.h"
#include "_eeprom_upload.h"
#include "_menu_text.h"
#include "_menu.h"
#include "_date_tools.h"
#include "_ld_measure.h" 


ISR(TIMER1_COMPA_vect) {
    static uint8_t save_sreg;
    save_sreg = SREG;
    static uint8_t scalieren = 0;    
    
    scalieren++;
    
    // zeit aktuallisieren -----------------------------------
    if (scalieren > 9 ) //9 = 1 zehntel Sekunde
    { 
        t_zsec++;  
        
        if (t_zsec > 9)   {t_zsec= 0; t_sec++; status_byte_time |= (1 << 0);}
        if (t_sec  > 59)  {t_sec = 0; t_min++; status_byte_time |= (1 << 1);}
        if (t_min  > 59)  {t_min = 0; t_std++; status_byte_time |= (1 << 2);}
        if (t_std  > 23)  {t_std = 0; status_byte_time |= (1 << 3);}
        
        scalieren = 0;
        
        
        //TIMEOUT --------------------------------------
        if ( TIMEOUT > 0  &&   status_byte_clock&(1 << 7) )
        {
            TIMEOUT--;
        }
        //TIMEOUT ENDE
        
        //SKIP    --------------------------------------
        if ( SKIP > 0 )
        {
            SKIP--;
        }
        //TIMEOUT ENDE
        
        //alarm Sound ----------------------------------
        if (status_byte_clock&(1 << 0))
        {
            if (!(t_sec%2)){_sound(1); status_byte_time |=(1<<5);}else{_sound(0);}   
        }
        
        if (status_byte_time&(1<<5) && !(status_byte_clock&(1 << 0))) 
        { 
            _sound(0); 
            status_byte_time &=~(1<<5);
        }
        
        
        
        // Button 1 ------------------------------------
        if ((bit_is_clear (PINC, 0)))
        {
            
            if ( status_button &(1<<0)) {status_button |=(1 << 1);}
            
            status_button |= (1 << 0);  
            
        }else{
            
            if ( status_button &(1<<1)){status_button &=~(1 << 0);}
        }
        
        // Button 2
        if ((bit_is_clear (PINC, 1)))
        {
            
            if ( status_button &(1<<2)) {status_button |=(1 << 3);}
            
            status_button |= (1 << 2);  
            
        }else{
            
            if ( status_button &(1<<3)){status_button &=~(1 << 2);}
        }
        
        // Button 3
        if ((bit_is_clear (PINC, 2)))
        {
            
            if ( status_button &(1<<4)) {status_button |=(1 << 5);}
            
            status_button |= (1 << 4);  
            
        }else{
            
            if ( status_button &(1<<5)){status_button &=~(1 << 4);}
        }
        
    }
    
    //ende  zeit aktuallisieren ------------------------------
    
    SREG = save_sreg;
    
}//ende interrupt timer1


//variante1 -----------------------------------------------------------------------------
//interupt button check und display multiplexing 
ISR(TIMER0_COMPA_vect) {
    static uint8_t save_sreg; save_sreg = SREG;
    
    static int8_t zeilen_position=14;
    uint16_t column=0x0;
    
    static uint16_t row=0b0000000000000010;
    uint8_t row_0to6=0;
    uint8_t row_6to13 = 0;
    
    RGB_BLUE_OFF;RGB_GREEN_OFF;RGB_RED_OFF;
    /*
     *  sr_clear_low;
     *  DisLoad;EnLoad;DisLoad;
     *  sr_clear_high;
     */
    row = (row << 1);
    zeilen_position-=1;
    //row=0b0000001000000000;
    row_6to13 = row;
    row_0to6  = (row >> 8);
    
    column = matrix[zeilen_position];
    _display (row_0to6,row_6to13,(column>>8), column);
    
    DisLoad; EnLoad;DisLoad;
    
    if ( rgb_led[zeilen_position] &(1<<1) ){RGB_BLUE_ON; }
    if ( rgb_led[zeilen_position] &(1<<2) ){RGB_RED_ON;  }
    if ( rgb_led[zeilen_position] &(1<<0) ){RGB_GREEN_ON;}
    
    
    
    if (zeilen_position == 0){row=0b0000000000000010;zeilen_position=14;}
    
    
    SREG = save_sreg;
    
}//ende display------------------------------------------------------------



int main(void)
{
    //Alle Rigister auf Eingang  
    DDRB =0b00000000; 
    DDRC =0b0000000;
    DDRD =0b00000000;
    
    //Alle PORTS Pull up Widerstände ausgeschaltet
    PORTB =0b00000000; 
    PORTC =0b0000000; 
    PORTD =0b00000000; 
    
    //Konfig RGB LED amd MPC  
    
    DDRD    |=0b01111111; 
    //DDRD  |= (1 << 0);  //rgb blue  output
    //DDRD  |= (1 << 1);  //rgb green output
    //DDRD  |= (1 << 2);  //rgb red   output
    //DDRD  |= (1 << 3);  //Register 3 auf Ausgang
    //DDRD  |= (1 << 4);  //Shiftregister 4 auf Ausgang
    //DDRD  |= (1 << 5);  //speaker
    //DDRD  |= (1 << 6);  //LDAC0 output
    
    EnLoad_MPC; //PORTD6 = Low
    
    //bright on
    PORTD	  &= ~(1 << PWM); //Port PWM = PD3  Low 
    
    
    //Konfig SRCLR for shiftregister
    //DDRD 	  |= (1 << 4); //Register 4 auf Ausgang
    PORTD	  |= (1 << 4); //Port auf High
    
    //Konfig Select auf Ausgang
    DDRB |= (1<<SELECT0_MPC); 
    DDRB |= (1<<SELECT1_MPC);
    DDRD |= (1<<SELECT2_SR);
    
    PORTB |= (1<<SELECT0_MPC);
    PORTB |= (1<<SELECT1_MPC);
    PORTD &= ~(1<<SELECT2_SR);
    
    
    //Konfig Taster
    PORTC |= 0b0001111; 
    //PORTC |= (1 << 0); //taster 0 PULL UP
    //PORTC |= (1 << 1); //taster 1 PULL UP
    //PORTC |= (1 << 2); //taster 2 PULL UP
    //PORTC |= (1 << 3); //Infra Rot 3 PULL UP 
    
    
    
    
    // timer0 interrupt ---------------------------------------------------------------
    // für button abfrage display
    
    // TIMSK0 |= (1<<TOIE0);// enable timer0
    
    TCNT0=0x00;// set timer0 counter to value 0
    
    TIMSK0 |= (1<<OCIE0A);              // den Output Compare Interrupt des Timers freigeben
    
    
    OCR0A  = 9;                     // 9 = ca 120 HZ , 18 =ca 60 Hz ,use 1024 prescaler  
    
    
    TCCR0A = (1<<WGM01 ) ;  //CTC Mode on
    TCCR0B = (1<<CS02) | (1<<CS00); 	//1024 prescaler  
    
    
    //TCCR0B = (1<<CS00) ; 		//no prescaler
    //TCCR0B = (1<<CS01) ; 		//8 prescaler
    //TCCR0B = (1<<CS01) | (1<<CS00); 	//64 prescaler
    //TCCR0B = (1<<CS02) ;		//256 prescaler 
    
    /*
     * Example: 
     * 1HZ     =1 second
     * 120HZ   =0,00833333.. (total 14 Row)
     * 
     * 1 row = 0,00833333 / 14 = 0,0005923..second = ca 600us
     * 1 row at HZ 1666,666.. 
     */
    
    //-----------------------------------------------------------------------------------
    
    
    //definiere PWM am Timer 2 --------------------------------------------------------------
    //Timer für Led Helligkeit
    
    TCNT2=0x0;
    OCR2B  = 100; //OCR2B_bright;//140 circa halbe Helligkeit (volle Helligkeit 0 keine Helligkeit 255)
    
    //TCCR2B |= (1 << CS20) ;    		// no prescale 
    TCCR2B |= (1 << CS21) ;    			// prescale 8 
    //TCCR2B |= (1 << CS21) | (1 << CS20);	// prescale 32
    //TCCR2B |= (1 << CS22) ;			// prescale 64
    
    TCCR2A |= (1<<COM2B1) | (1 <<  WGM21) | ( 1 << WGM20); 
    
    DDRD |= (1<<PD3);// Output PortD Pin 3 for PWM out set
    
    //--------------------------------------------------------------------------------------
    
    
    // definiere Sekunden Takt am Timer 1  ----------------------------------------------
    // timer interupt -------------------------------------------------------------------
    
    TCNT1=0x0;
    TIMSK1 |= (1<<OCIE1A);              // den Output Compare Interrupt des Timers freigeben
    //OCR1A  = 200-1;                   // nach 200 Zaehlschritten -> Interrupt und Timer auf 0  ergibt 1/10000 tausenstel sek.prescale 8
    //OCR1A  = 250-1;                   // nach 500 Zaehlschritten -> Interrupt und Timer auf 0  ergibt 1/1000 tausenstel sek.prescale 32
    
    
    //TCCR1B = (1 << CS11) | (1<<WGM12);    // Vorteiler 8 , und CTC mode
    //TCCR1B = (1 << CS11) | ( 1 << CS10) | (1<<WGM12);    // Vorteiler 64 , und CTC mode
    
    OCR1A  = 625-1;  //1 hunderstel sekunde
    TCCR1B = (1 << CS12) | (1<<WGM12);    // Vorteiler 256 , und CTC mode
    //---------------------------------------------------------------------------------
    
    
    
    //--------------------------------------------------------------------------------------
    
    _MPC(0,0b01111111,0b11110000); // led rot  ,device MPC4902
    _MPC(0,0b11111111,0b11110000); // led blau ,device MPC4902
    
    _MPC(1,0b01111111,0b11110000); // led grün,,device MPC4901
    
    //Led and matrix clear
    _LED_CLEAR();
    _display(0b00000000, 0b00000000,0b00000000,0b00000000);
    
    sei();//aktiviere globaler interrupt
    
    
    uint16_t LD_value=0;
    uint16_t LD_value_prev=0;
    uint8_t  LD_level=9;
    uint8_t  LD_snooze_level=0;
    uint8_t  LD_snooze_counter=0;
    
    uint8_t show=0;
    uint8_t count=0x0;
    uint8_t menu=0;
    
    // I2C Bus enable
    _i2c_init();
    
    _RTC_DS1307_Read_Write_init (0x3F, 1 );//Read_Write  Read = 1 , Write = 0
    BCD_2Digit =_I2C_Read_data (1);
    
    if (  !(status_byte_clock &(1<<3))) //RTC connected
    {
        
        if (BCD_2Digit != 0b01101000) 
        {
            _RTC_DS1307_Read_Write_init (0x00, 0 );//Read_Write  Read = 1 , Write = 0
            
            _I2C_Write_data (0,0);		// ADDRESS 00, write sec.
            _I2C_Write_data (0,0);		// ADDRESS 01, write min. 
            _I2C_Write_data (0,0);		// ADDRESS 02, write std. 
            _I2C_Write_data (0,0);		// ADDRESS 03, write day 1 DUMMY
            _I2C_Write_data (0x01,0);		// ADDRESS 04, write date 1 (1-31)
            _I2C_Write_data (0x01,0);		// ADDRESS 05, write month 1
            _I2C_Write_data (0x0F,0);		// ADDRESS 06, write year (15)
            _I2C_Write_data (0,0);		// ADDRESS 07, sqwe = aus DUMMY read
            
            
            _RTC_DS1307_Read_Write_init (0x3F,0);	//Read_Write  Read = 1 , Write = 0 ,end of ram 3F
            _I2C_Write_data (0b01101000 , 1);	// First Initialisierung 
            
            
            // writte default setting, first time
            _RTC_DS1307_Read_Write_init (0x08 ,0 ); //start at address 0x08 
            
            for (count = 0x08;count < 0x17 ;count++) // writte untill address 0x16
            {
                _I2C_Write_data (0,0); //writte zeros alarm time
            }
            
            //_RTC_DS1307_Read_Write_init (0x17 ,0 ); //start at address 0x08 
            _I2C_Write_data (alarm_status,0);		//writte alarm_status 
            _I2C_Write_data (sensor_set,0);		//writte RGBM_Bright 
            _I2C_Write_data (screen,0);		//writte screen    
            _I2C_Write_data (status_byte_clock,0);	//writte status_byte_clock
            
            _I2C_Write_data (RGBM_Bright[0],0);	//writte RGBM_Bright 
            _I2C_Write_data (RGBM_Bright[1],0);	//writte RGBM_Bright 
            _I2C_Write_data (RGBM_Bright[2],0);	//writte RGBM_Bright 
            _I2C_Write_data (RGBM_Bright[3],0);	//writte RGBM_Bright matrix  
            
            _I2C_Write_data (ring_set,1);	//writte Ring Set  
            
            // Ende Init -----------------------------------------------------------------------
            
        }else{
            
            // RTC DS1307 LOAD TIME-------------------------------------------------------------
            _RTC_DS1307_Read_Write_init (0x00, 1 );//Read_Write  Read = 1 , Write = 0
            
            t_sec =_load_RTC_Binary(0);		// ADDRESS 00, load sec.
            t_min =_load_RTC_Binary(0);		// ADDRESS 01, load min.
            t_std =_load_RTC_Binary(0);		// ADDRESS 02, load std. 
            
            _I2C_Read_data (0);			// ADDRESS 03, load day (1-7) DUMMY read 
            
            day   =_load_RTC_Binary(0);		// ADDRESS 04, load date (1-31)
            month =_load_RTC_Binary(0);		// ADDRESS 05, load month
            year  =_load_RTC_Binary(0);		// ADDRESS 06, load year
        
            
            _I2C_Read_data (1);			// ADDRESS 07, sqwe = aus DUMMY read
            
            
            // Read default setting by every clock start ----------------------------------------
            _RTC_DS1307_Read_Write_init (0x08 ,1 );  //start at address 0x08 
            
            for (count = 0;count < 7 ;count++ ) // read untill address 0x16
            {
                alarm_std[count] = _I2C_Read_data (0); //read zeros
                alarm_min[count] = _I2C_Read_data (0); //read zeros
                
                //correct
                if (alarm_std[count] >23 ) {alarm_std[count]=23;} 
                if (alarm_min[count] >59 ) {alarm_min[count]=59;}
                
            }
            
            //_RTC_DS1307_Read_Write_init (0x16 ,1 );  //start at address 
            alarm_nr          = _I2C_Read_data (0);	//read alarm_nr 
            alarm_status      = _I2C_Read_data (0);	//read alarm_status 
            sensor_set        = _I2C_Read_data (0);	//read RGBM_Bright 
            screen            = _I2C_Read_data (0);	//read screen    
            status_byte_clock = _I2C_Read_data (0);	//read status_byte_clock
            
            RGBM_Bright[0]    = _I2C_Read_data (0);	//read RGBM_Bright 
            RGBM_Bright[1]    = _I2C_Read_data (0);	//read RGBM_Bright 
            RGBM_Bright[2]    = _I2C_Read_data (0);	//read RGBM_Bright 
            RGBM_Bright[3]    = _I2C_Read_data (0);	//read RGBM_Bright matrix   
            
            ring_set		= _I2C_Read_data (1);	//read ring mod 
            
            alarm_status      &= ~0b11011010 ;   // status set
            status_byte_clock &= ~0b11011001 ;   // status set
            
            //correct
            if (t_std  > 23 )  {t_std = 23;} 
            if (t_min  > 59 )  {t_min = 59;}
          
            
            if (day   > 31 ) {day   =31;}
            if (month > 12 ) {month =12;}
            if (year  > 99 ) {year  =99;}
            
            
            if (  alarm_nr > 7)        {  alarm_nr=7;}
            if (  ring_set > 2)        {  ring_set=2;}
            if (  RGBM_Bright[0] > 9 ) {  RGBM_Bright[0] = 5;}
            if (  RGBM_Bright[1] > 9 ) {  RGBM_Bright[1] = 5;}
            if (  RGBM_Bright[2] > 9 ) {  RGBM_Bright[2] = 5;}
            if (  RGBM_Bright[3] > 9 ) {  RGBM_Bright[3] = 5;}
            
        }
    } 
    
    
    //_eeprom_upload ---------------------------------------------------------------------
    _MATRIX_CLEAR();
    _LED_CLEAR();
    _sound(0);//sound off
    _menu_titel(19,0,1);
    _eeprom_upload_ziffern_gross(ADDRESS_DIGITS_BIG);
    _eeprom_upload_ziffern_klein(ADDRESS_DIGITS_SMALL);
    _eeprom_upload_alphabet(ADDRESS_DIGITS_ABC);
    
    _LED_CLEAR();
    _MATRIX_CLEAR();
    
    final_alarm_min = alarm_min[alarm_nr];
    final_alarm_std = alarm_std[alarm_nr];
    
    while(1)
    {
        
        
        // settings --------------------------------------------------------------------------   
        if (status_button  &(1<<1)) {status_byte_clock |= (1 << 6);menu=1;TIMEOUT= TIMEOUTCOUNTER;status_byte_clock |= (1<<7);}
        
        while (status_byte_clock &(1<<6))
        { 
            
            if ( !(status_byte_time  &(1<<4))) { OCR2B  =   50 ;}                     //black out matrix bright  
            
            if (status_button &(1<<1) &&  (!(status_button &(1<<0))) )
            {
                
                _delay_ms(120);
                status_button = 0;    
                _beep();
                
                switch(menu)
                {
                    default:;
                    
                    case 1: 
                        menu=2;
                        _MATRIX_CLEAR();
                        _menu_titel(1,0,1);
                        _alarm_set();      
                        break;
                        
                    case 2:
                        menu=3;
                        _MATRIX_CLEAR();
                        _menu_titel(2,0,1);
                        _time_set();   
                        break;
                        
                    case 3:
                        menu=4;
                        _MATRIX_CLEAR();
                        _menu_titel(3,0,1);
                        _date_set();      
                        break;
                        
                    case 4:
                        menu=5;
                        _MATRIX_CLEAR();
                        _menu_titel(4,0,1);
                        _screen_set();
                        break;
                        
                    case 5:
                        menu=6;
                        _MATRIX_CLEAR();
                        _menu_titel(20,0,1);
                        _ring_set();
                        break;
                        
                    case 6:
                        menu=7;
                        _MATRIX_CLEAR();
                        _menu_titel(5,0,1);
                        _bright_set();
                        break;
                        
                    case 7:
                        menu=8;
                        _MATRIX_CLEAR();
                        _menu_titel(6,0,1);
                        _glow_set();
                        break;
                        
                    case 8:
                        menu=9;
                        _MATRIX_CLEAR();
                        _menu_titel(7,0,1);
                        _sensor_set();
                        break;
                        
                    case 9:
                        menu=10;
                        _MATRIX_CLEAR();
                        _menu_titel(8,0,1);
                        _beep_set();
                        break;
                        
                    case 10:
                        menu=11;
                        _MATRIX_CLEAR();
                        _menu_titel(9,0,1);
                        _info();
                        break;
                        
                        
                    case 11:
                        TIMEOUT=0;   
                        break;
                        
                }//ende switch
                
                
                if (TIMEOUT < 1 || status_button&(1 << 3 ) )
                {   
                    status_byte_clock &= ~(1 << 6); //leave loop
                    status_byte_clock |=  (1 << 4); //prepare matrix display      
                    
                    
                    _delay_ms(150);
                    status_button =0;
                    
                    final_alarm_min = alarm_min[alarm_nr];
                    final_alarm_std = alarm_std[alarm_nr];
                }
                
                TIMEOUT = TIMEOUTCOUNTER;
                
                
                if (status_button &(1 << 1) ){status_button = (1 << 1);      }else{
                    status_button &= ~(1 << 0);    
                    status_button &= ~(1 << 1);
                    
                }
            }
            
        }
        
        
        //prepare matrix---------------------------------------------------------------------- 
        if (status_byte_clock&(1<< 4))
        {
            _MATRIX_CLEAR();
            _LED_CLEAR();
            status_byte_time |=0b01010111; //load alarm_status, std,min,sec, (1<<4)black out is set
            
            status_byte_clock&=~(1<< 4);  
            
            
        }
        //prepare matrix ende----------------------------------------------------------------- 
        
        
        
        //alarm set (1-7) or show date -------------------------------------------------------
        if (status_button  &(1<<3) && !(alarm_status & (1<<1))  ) 
        { 
            if ( !(status_byte_time  &(1<<4))) { OCR2B  =   50 ;}                     //black out matrix bright  
            
            SKIP=25;
            while ( status_button &(1<<3) && status_button &(1<<2) && SKIP);
            
            if (SKIP > 0)
            {
                
                _alarm_time_change();
                _LED_CLEAR();
                
                final_alarm_min = alarm_min[alarm_nr];
                final_alarm_std = alarm_std[alarm_nr];
                _I2C_Write_data (alarm_status,1);// write new alarm tim into the RTC 
                
            }else{
                _MATRIX_CLEAR();
                _show_date();
                _delay_ms(5000);
                _MATRIX_CLEAR();
                _LED_CLEAR();
                
            }
            status_button &=~ ( (1 << 3) | (1 <<2));
            status_byte_time |=0b01010111; //load alarm_status, std,min,sec, (1<<4)black out is set
        }
        // alarm set ende --------------------------------------------------------------------
        
        
        //alarm on off     -------------------------------------------------------------------
        if (status_button  &(1<<5)) 
        { 
            _beep();
            if (screen == 2){_MATRIX_CLEAR();_LED_CLEAR();}
            if (screen == 3){_MATRIX_CLEAR();_LED_CLEAR();}
            
            
            if (alarm_status&(1 << 0))
            {
                status_byte_clock &=~0b10000001;
                //status_byte_clock &=~(1<<0);   //alarm off
                //status_byte_clock &=~(1<<7);   //Timout off
                
                alarm_status &=~0b11001111;
                //alarm_status &=~(1<<0);//alarm off
                //alarm_status &=~(1<<1);//alarm sound off
                //alarm_status &=~(1<<2);//LD get up off
                //alarm_status &=~(1<<3);//show snooze off
                //alarm_status &=~(1<<6);//glow off
                //alarm_status &=~(1<<7);//glow off
                
                _RTC_write_alarmstatus();
                
            }
            else
            {
                
                alarm_status |=(1<<0);
                final_alarm_min = alarm_min[alarm_nr];
                final_alarm_std = alarm_std[alarm_nr];
                
                _RTC_write_alarmstatus();
                
            }
            
            _delay_ms(150);
            status_button=0;
            status_byte_time |=0b01010111; //load alarm_status,  std,min,sec, (1<<4)black out is set
            
        }
        // alarm on/off ende -----------------------------------------------------------------
        
        
        
        
        
        // enter in when a second change ----------------------------------------------------------------------------------------
        if ( status_byte_time&(1 << 0) )
        {
            
            
            // date update ---------------------------------------------------------------------
            if ( status_byte_time  &(1<<3))
            {
                _update_date();  
                status_byte_time &=~(1<<3);
            }
            // settings end --------------------------------------------------------------------
            
            
            //Light Diode ------------------------------------------------------------------------
            
            LD_value =  _ld_read();
            if(  ((LD_value_prev - LIGHT_TRIGGER) > LD_value) || ((LD_value_prev + LIGHT_TRIGGER) < LD_value) )
            {
                LD_value_prev = LD_value;
                
                LD_level = (LD_value/100)-1;
                LD_level =9-LD_level;
                if (LD_level > 9){LD_level=9;} //max. level 9
            }
            
            //Light Diode END --------------------------------------------------------------------
            
            
            // black out -------------------------------------------------------------------------
            if ( !(status_byte_time  &(1<<4)))
            {
                
                if (!(t_sec%2)) 
                { 
                    OCR2B  =  50 ;                     //matrix bright  
                }else{ 
                    
                    OCR2B  = 255 ;                     //matrix black  
                }     
            }
            // black out end end --------------------------------------------------------------------
            
            
            //Bright Auto Adjust -----------------------------------------------------------------
            //Function disabled when the glow is active
            
            if ( (!(alarm_status&(1 << 7)) &&  !(alarm_status &(1 << 6))) &&  status_byte_time  &(1<<4) )
            {
                
                
                if  (sensor_set&(1<<0))  // sensor select = (1<<0) = 1, = bright auto adjust
                {
                    
                    _bright_level (LD_level);
                    _LED_BRIGHT_LEVEL (rgb_dim_level[0],rgb_dim_level[1], rgb_dim_level[2]);
                    
                }else{
                    
                    // individual bright set ---------------------
                    _ONE_RGB_BRIGHT(0, RGBM_Bright[0]); //blue
                    _ONE_RGB_BRIGHT(1, RGBM_Bright[1]); //green
                    _ONE_RGB_BRIGHT(2, RGBM_Bright[2]); //red
                    _ONE_RGB_BRIGHT(3, RGBM_Bright[3]); //matrix
                    //--------------------------------------------  
                }
                
            }
            
            //Bright Auto Adjust END -------------------------------------------------------------
            
            
            
            //light diode snooze ---------------------------------------------------------------
            
            if  (sensor_set&(1<<1)) 
            {
                
                
                if ( (LD_snooze_level != LD_level) && (LD_snooze_counter == 1) )
                {
                    SKIP = 30;
                    TIMEOUT= TIMEOUTCOUNTER_SNOOZE;  
                    status_byte_clock |= (1<<7);
                    
                    LD_snooze_counter=2; 
                    alarm_status |=(1 << 2);// LD get up 
                    LD_snooze_level =LD_level;
                    
                }
                
                if (LD_snooze_level != LD_level &&  (LD_snooze_counter == 2))
                {
                    LD_snooze_counter=3;
                    LD_snooze_level =LD_level;  
                }
                
                if ( (SKIP < 1) && (LD_snooze_counter == 2))
                {
                    status_byte_clock &=~(1<<0);    //alarm sound off
                    
                }
                
                
                if ( (alarm_status &(1 << 1)) && (TIMEOUT > 1 ) && (LD_snooze_counter >= 3))
                {
                    status_byte_clock &=~(1<<0); //alarm sound off
                    alarm_status |= (1 << 3);    //show snooze
                    
                    alarm_status &=~0b01000010;
                    //alarm_status &=~(1 << 1);//alarm off
                    //alarm_status &=~(1 << 6);//glow off 
                    
                    LD_snooze_counter = 0;
                    
                    final_alarm_min += SNOOZE_TIME;
                    if (final_alarm_min > 59) {final_alarm_std ++; final_alarm_min = final_alarm_min%60; }
                    if (final_alarm_std > 23) {final_alarm_std =0; }
                    
                    _LED_CLEAR();
                    _show_led_ring(2);
                }
                
                
                
                if ( TIMEOUT < 1 && (LD_snooze_counter == 2) && alarm_status&(1<<1) )
                {
                    _MATRIX_CLEAR();
                    _LED_CLEAR();
                    
                    status_byte_clock &=~0b10000001;
                    //status_byte_clock &=~(1<<0);//alarm sound off
                    //status_byte_clock &=~(1<<7);//Timout off
                    
                    alarm_status &=~0b11001111;
                    //alarm_status &=~(1<<0);//alarm off
                    //alarm_status &=~(1<<1);//active alarm off (sound ringing)
                    //alarm_status &=~(1<<2);//LD get up off
                    //alarm_status &=~(1<<3);//show snooze off
                    //alarm_status &=~(1<<6);//glow off 
                    //alarm_status &=~(1<<7);//glow off
                    
                    status_byte_time |=0b01000111; //prepare to load alarm_status, std,min,sec
                    
                    LD_snooze_counter = 0;
                    _RTC_write_alarmstatus();
                }
                
                
                
            }
            //light diode snooze end -----------------------------------------------------------
            
            
            
            //alarm wake up --------------------------------------------------------------------
            if (alarm_status&(1<<0)){
                
                if ( (final_alarm_min == t_min  && final_alarm_std == t_std && t_sec < 1) )
                {
                    
                    _MATRIX_CLEAR();
                    
                    alarm_status &=~(1 << 3);   //show snooze off
                    alarm_status |= 0b01000010;
                    //alarm_status      |= (1 << 1);   //alarm on
                    //alarm_status      |= (1 << 6);   //glow (alarming)
                    
                    status_byte_clock |= (1 << 0);   //alarm sound on 
                    
                    
                    //Light Diode -----------------------------------
                    if  (sensor_set&(1<<1)) // wake light diode on
                    {
                        LD_snooze_level=LD_level;
                        LD_snooze_counter=1; 
                    }
                    //Light Diode END -------------------------------
                    
                }
                
                //glow
                if (alarm_status&(1 << 5))
                {
                    _alarm_glow(); 
                }
                
            }   
            //alarm wake up end ----------------------------------------------------------------
            
            
            // if alarm sound off and snooze off, then show screen 2 or screen 3----------------
            if ( !(alarm_status&(1<<1)) && !(alarm_status&(1<<3)) ){
                // Screen 1 show the alarm time on the matrix
                if (screen ==1)
                { 
                    _show_alarm_time(alarm_nr);_show_led_ring(0); 
                }
                //----------------------------------------------------------------------------------
                
                // Screen 2 show the time on the matrix and on the led ring, 
                // when the alarm is set then schow the time on the matrix and the alarm time on the led ring
                if (screen ==2)
                {
                    
                    _show_time();
                    
                    if (alarm_status&(1 << 0))
                    {
                        
                        _show_led_ring(1);
                        
                    }else{
                        
                        _show_led_ring(0);   
                    }
                }
                //----------------------------------------------------------------------------------
                
                
                // Screen 3 show the date on the matrix and the time on the led ring, 
                // when the alarm is set then schow the time on the matrix and the alarm time on the led ring
                if (screen ==3)
                {
                    
                    if (alarm_status&(1 << 0))
                    {
                        _show_time();
                        _show_led_ring(1);
                        
                    }else{
                        
                        _show_date();
                        _show_led_ring(0);  
                    }
                }
                
                // show alarm status
                if ( status_byte_time&(1<<6))
                {
                    _show_alarmstatus();
                    status_byte_time &=~(1<<6);
                    
                }
                
            }
            //------------------------------------------------------------------------------------
            
            
            //  if the alarm on and the light diode was triggerd, or the alarm is on or the snooze is active, then schow the alarm text
            //  if ( (alarm_status&(1<<1) &&  alarm_status&(1<<2)) || ( alarm_status&(1<<1) && alarm_status&(1<<3)) )
            if ( ( alarm_status&(1<<1) || alarm_status&(1<<3)) || ( alarm_status&(1<<1) && alarm_status&(1<<2)) )
            {
                
                if ( !(t_sec%2) ) {show=1;}else{show=0;} // let's blink the text output , syncron with black out when active
                
                
                if ( alarm_status &(1 << 3) )
                {
                    
                    _menu_titel(17,0,show); //show snooze
                }else{
                    
                    if (alarm_status&(1<<2))
                    {
                        _menu_titel(25,0,show); //show get up
                        
                    }else{
                        
                        _menu_titel(16,0,show); //show wake up
                        
                    } 
                }
            }
            
            status_byte_time &=~(1 << 0);
            
        }
    } 
}
