//RGB Colour Clock Driver alpha 1.0

//Written by Christoph Kreis
//You can change the code if you like or share it with your friends, but it's not allowed to deal with the code.


void _MPC(int device, char daten_low ,char daten_high)
{
 
  cli(); // clear interupt
  if (device < 1)
  {
    /* Set MOSI and SCK output, all others input */
    //DDRB = (1<<MOSI)|(1<<SCK)| (1<<LOAD);
    
    DDRB = (1<<MOSI)|(1<<SCK) |(1 << SELECT0_MPC) ;
    /* Enable SPI, Master, set clock rate fck/16 */
    // SPCR = (1<<SPE)|(1<<MSTR)|(1<<SPR0)|(1<<DORD);//(1<<DORD) = the DORD bit is written to one, the LSB of the data word is transmitted first.
    SPCR = (1<<SPE)|(1<<MSTR)|(1<<SPR0);  //the LSB of the data word is transmitted last
    
    
    //PORTB |=(1<< SELECT0_MPC);
    
    PORTB &=~ (1 << SELECT0_MPC);
    
    SPDR = daten_low;
    while(!(SPSR & (1<<SPIF)));
    
    SPDR = daten_high;
    while(!(SPSR & (1<<SPIF)));
    
    
    
    
    PORTB |=(1<< SELECT0_MPC);
    
    
    
    
  }else{
    /* Set MOSI and SCK output, all others input */
    //DDRB = (1<<MOSI)|(1<<SCK)| (1<<LOAD);
    
    DDRB = (1<<MOSI)|(1<<SCK) |(1 << SELECT1_MPC) ;
    /* Enable SPI, Master, set clock rate fck/16 */
    //SPCR = (1<<SPE)|(1<<MSTR)|(1<<SPR0)|(1<<DORD);//(1<<DORD) = the DORD bit is written to one, the LSB of the data word is transmitted first.
    SPCR = (1<<SPE)|(1<<MSTR)|(1<<SPR0);//the LSB of the data word is transmitted last
    
    PORTB &=~ (1 << SELECT1_MPC);
    
    SPDR = daten_low;
    while(!(SPSR & (1<<SPIF)));
    
    
    SPDR = daten_high;
    while(!(SPSR & (1<<SPIF)));
    
    
    
    PORTB |=(1<<  SELECT1_MPC);
    
    
  }
  sei(); // start interupt
  
}


void _display(uint8_t zeile_up,uint8_t zeile_down,uint8_t spalte_left,uint8_t spalte_right)
{
  /* Set MOSI and SCK output, all others input */
  //DDRB = (1<<MOSI)|(1<<SCK)| (1<<LOAD);
  
  DDRB = (1<<MOSI)|(1<<SCK) ;
  
  /* Enable SPI, Master, set clock rate fck/16 */
  //SPCR = (1<<SPE)|(1<<MSTR)|(1<<SPR0)|(1<<DORD);//(1<<DORD) = the DORD bit is written to one, the LSB of the data word is transmitted first.
  //DisLoad
  
  
  SPCR = (1<<SPE)|(1<<MSTR)|(1<<DORD);//(1<<DORD) = the DORD bit is written to one, the LSB of the data word is transmitted first. set clock rate fck/4 */
  
  // Start transmission x_cord 
  SPDR =  zeile_down ;
  // Wait for transmission complete
  while(!(SPSR & (1<<SPIF)));
  
  // Start transmission x_cord 
  SPDR = zeile_up  ;
  // Wait for transmission complete
  while(!(SPSR & (1<<SPIF)));
  DDRD |= (1 << SELECT2_SR) ;
  
  
  // Start transmission y_cord
  SPDR = spalte_right;
  // Wait for transmission complete 
  while(!(SPSR & (1<<SPIF)));
  
  // Start transmission y_cord
  SPDR = spalte_left;
  // Wait for transmission complete 
  while(!(SPSR & (1<<SPIF)));   
 
}
