//RGB Colour Clock Driver alpha 1.0

//Written by Christoph Kreis
//You can change the code if you like or share it with your friends, but it's not allowed to deal with the code.



 void _month(uint8_t month_nr,uint8_t position,uint8_t show)
 {
   switch(month_nr)
     
   {
     default:;
     
     case 1:  
       _alphabet_load(j,0 + position,  show);
       _alphabet_load(a,4 + position,  show);
       _alphabet_load(n,9 + position,  show);    
       break;
       
     case 2:
       _alphabet_load(f,0 + position,  show);
       _alphabet_load(e,5 + position,  show);
       _alphabet_load(b,10 + position,  show);  
       break;
       
     case 3:
       _alphabet_load(m,0 + position,  show);
       _alphabet_load(space,5 + position,  show);
       _alphabet_load(a,6 + position,  show);
       _alphabet_load(r,11 + position,  show);  
       break;
       
     case 4:
       _alphabet_load(a,0 + position,  show);
       _alphabet_load(p,5 + position,  show);
       _alphabet_load(r,10 + position,  show);  
       break;
       
     case 5:
       _alphabet_load(m,0 + position,  show);
       _alphabet_load(space,5 + position,  show);
       _alphabet_load(a,6 + position,  show);
       _alphabet_load(i,11 + position,  show);  
       break;
       
     case 6:
       _alphabet_load(j,0 + position,  show);
       _alphabet_load(u,4 + position,  show);
       _alphabet_load(n,9 + position,  show);   
       break;
       
     case 7:
       _alphabet_load(j,0 + position,  show);
       _alphabet_load(u,4 + position,  show);
       _alphabet_load(l,9 + position,  show);  
       break;
       
     case 8:
       _alphabet_load(a,0 + position,  show);
       _alphabet_load(u,5 + position,  show);
       _alphabet_load(g,10 + position,  show);  
       break;
       
     case 9:
       _alphabet_load(s,0 + position,  show);
       _alphabet_load(e,5 + position,  show);
       _alphabet_load(p,10 + position,  show);  
       break;
       
     case 10:
       _alphabet_load(o,0 + position,  show);
       _alphabet_load(c,5 + position,  show);
       _alphabet_load(t,10 + position,  show);  
       break;
       
     case 11:
       _alphabet_load(n,0 + position,  show);
       _alphabet_load(o,5 + position,  show);
       _alphabet_load(v,10 + position,  show);  
       break;
       
     case 12:
       _alphabet_load(d,0 + position,  show);
       _alphabet_load(e,5 + position,  show);
       _alphabet_load(z,10 + position,  show);  
       break;
       
   }
   
   if (month_nr == 3){ matrix[13] |=  (1 << 14);}
   else{ matrix[13] |= (1 << 15);matrix[13] &= ~(1 << 14);}
   
 }
 
 
 
 
 uint8_t _monthend(uint16_t year, uint8_t month)
 {
   uint16_t monthend=0b0001010110101010;
   uint8_t  month_days=30;
   
   if (month == 2)
   {
     
     month_days=28;
     if ( (year%4) < 1 ){month_days =29;}//leap year yes or no ?
     
   }
   else
   {
     
     if ( monthend&(1 << month) ){month_days=31;}
     
   }
   
   return month_days;
   
 }
 
 void _update_date(void)
 {
   uint8_t  month_end=0;    
   uint8_t  temp_time=0;
   
   month_end =  _monthend(year,month);
   
   day++;
   
   if ( day >  month_end)
   {
     month++;
     day=1;
   
   //update the rtc module time every monthend --------------------------------------------------------------------------  
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     _RTC_DS1307_Read_Write_init (0x00, 0 );//Start Adresse 00 (sec), Read_Write  Read = 1 , Write = 0
     
     temp_time = _Binary_to_BCD2Digit(t_sec);
     _I2C_Write_data (temp_time,0); 
     
     temp_time = _Binary_to_BCD2Digit(t_min);
     _I2C_Write_data (temp_time,0); 
     
     temp_time = _Binary_to_BCD2Digit(t_std);
     _I2C_Write_data (temp_time,1); 
   }
   //Ende Write RTC-------------------------------------------------------------------------------------------------------
       
  }
   
   if (month > 12)
   {
     month=1;
     day=1;
     year++;
     
     if (year > 99){year=0;day=1;month=1;}
   } 
 }
 
 
 
 
 
 void _show_date(void)
 {  
   _month(month,0,1);
   ziffer_load(day/10,21,1);
   ziffer_load(day%10,26,1);
 }
 
 
 
 void _date_set(void)
 {
   uint8_t temp_year_month_day[3];
   uint8_t button3_count_cycle=0;
   uint8_t blink[3]={1,1,1};         	//let the digit blink (0=hide,1=show)
   uint8_t choice=0;
   uint8_t month_end=31;
   
   uint8_t status_timeset=0b00000001;
   //status_timeset = (1<<0) = show year
   //status_timeset = (1<<1) = show month
   //status_timeset = (1<<2) = show day
   //status_timeset = (1<<3) = toggle blink
   //status_timeset = (1<<7) = leave loop  
   
   temp_year_month_day[0]=year;
   temp_year_month_day[1]=month;
   temp_year_month_day[2]=day;
   
   
   TIMEOUT= TIMEOUTCOUNTER;    		// set TIMEOUT
   status_byte_clock |= (1<<7);		// start TIMEOUT
   _delay_ms(150);
   status_button=0;			//all buttons reset
   
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   _MATRIX_CLEAR();
   status_button=0;			//all buttons reset
   _beep();
   
   //show year
   _alphabet_load(y,0,1);
   _alphabet_load(e,5,1);
   _alphabet_load(a,10,1);
   _alphabet_load(r,15,1);
   
   
   while (! (status_timeset &(1<<7)))
   {
     //set year----------------
     if (status_timeset&(1<<0))
     {
       if (temp_year_month_day[0] > 99){temp_year_month_day[0] = 0;}
       
       ziffer_load(temp_year_month_day[0] / 10,  21,blink[0]);
       ziffer_load(temp_year_month_day[0] % 10,  26,blink[0]);
       
       status_timeset &=~(1<<0); 
       
     }
     
     //set month------------------------
     if (status_timeset&(1<<1))
     {
       if (temp_year_month_day[1] > 12){temp_year_month_day[1] = 1;}
       
       _month(temp_year_month_day[1] ,0,blink[1]);
       status_timeset &=~(1<<1); 
       
       
       
     }
     
     //set day------------------
     if (status_timeset&(1<<2))
     {
       if (temp_year_month_day[2] > month_end){temp_year_month_day[2] = 1;}
       
       ziffer_load(temp_year_month_day[2] / 10,  21,blink[2]);
       ziffer_load(temp_year_month_day[2] % 10,  26,blink[2]);
       status_timeset &=~(1<<2); 
     }
     
     
     
     if ( button3_count_cycle > 10 ){_delay_ms(100);button3_count_cycle=11;}else{_delay_ms(350); }
     
     if ( status_button&(1<<5) && (!(status_button&(1<<4))) ) {button3_count_cycle=0; status_button=0;}             
     if ( status_button&(1<<4) && (!(status_button&(1<<5))) ) {status_button=0;}
     //reset button 3 
     
     SKIP = 8;
     //wait until a button is pressed
     while ( (!(status_button &(1<<3))) && (!(status_button &(1<<4))) && SKIP );  
     if  ( TIMEOUT < 1 ) {return;}
     
     
     //toggle blink digit ------------------------------------------------------------------------------------------------------
     if (SKIP<1)
     {
       if (status_timeset &(1<<3)){ blink[choice]=1; status_timeset &=~(1<<3);}else{blink[choice]=0; status_timeset |= (1<<3); }
       // toggle the blink variable
     }
     
     if (status_button&(1<<4))
     {
       temp_year_month_day[choice]++;
       TIMEOUT= TIMEOUTCOUNTER;
       blink[choice]=1;
       _beep();
       
       if ( status_button &(1<<4) && status_button &(1<<5) )
       {
	 button3_count_cycle++;   
       }  
     }
     
     // when the bottom 2 was pressed prepare to go the next digit and reset all button
     if (status_button&(1<<3) && (!( status_button&(1<<2))))  
     {
       _beep();
       choice++; 
       //_delay_ms(150);
       status_button=0; 
       TIMEOUT= TIMEOUTCOUNTER;
       
       if (choice == 1){status_timeset |=(1<<1);status_timeset |=(1<<2);blink[1]=1;blink[2]=1;_MATRIX_CLEAR();}
       if (choice == 2){status_timeset |=(1<<1);status_timeset |=(1<<2);blink[1]=1;blink[2]=0;month_end=_monthend(temp_year_month_day[0], temp_year_month_day[1]);}
       
     }else{
       
       if (choice == 0){status_timeset |=(1<<0);}
       if (choice == 1){status_timeset |=(1<<1);}
       if (choice == 2){status_timeset |=(1<<2);}     
     }
     
     //prepare to leave the loop "while (! (status_timeset &(1<<7)))"
     if(choice > 2){status_timeset = (1<<7);}
     
   }
   
   //wiritte time -------------------------------------------------------------------------------------------------------------------
   _MATRIX_CLEAR();
   year = temp_year_month_day[0];
   month = temp_year_month_day[1];
   day = temp_year_month_day[2];
   
   ///RTC ----------------------------------------------------------------------------------------------------
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     _RTC_DS1307_Read_Write_init (0x04, 0 );//Start Adresse 04 (date 1-31), Read_Write  Read = 1 , Write = 0
     
     temp_year_month_day[2] = _Binary_to_BCD2Digit(temp_year_month_day[2]);
     _I2C_Write_data (temp_year_month_day[2],0);				//Adresse 04, write date 1 (1-31) 
     
     temp_year_month_day[1] = _Binary_to_BCD2Digit(temp_year_month_day[1]);
     _I2C_Write_data (temp_year_month_day[1],0);				//Adresse 05, write month 1-12
     
     temp_year_month_day[0] = _Binary_to_BCD2Digit(temp_year_month_day[0]);
     _I2C_Write_data (temp_year_month_day[0],1);			        //Adresse 06, write year;
   }
   // end ----------------------------------------------------------------------------------------------------
   
   status_button|=(1 << 3); 
 }
 
 
 
