//RGB Colour Clock Driver alpha 1.1

//Written by Christoph Kreis
//You can change the code if you like or share it with your friends, but it's not allowed to deal with the code.


 
 void _alarm_set(void)
 {
   uint8_t temp_alnr_std_min[3];
   uint8_t button3_count_cycle=0;
   uint8_t blink[3]={1,1,1};         	//let the digit blink (0=hide,1=show)
   uint8_t choice=0;
   uint8_t ADRESS_RTC=0;                 
   
   uint8_t status_menuset=0b00000111;
   //status_menuset = (1<<0) = show alarm_nr
   //status_menuset = (1<<1) = show std 
   //status_menuset = (1<<2) = show min  
   //status_menuset = (1<<3) = toggle blink
   //status_menuset = (1<<7) = leave loop  
   
   temp_alnr_std_min[0]=0;//zuweisung alarm nr.
   
   /* 
    *  TIMEOUT= TIMEOUTCOUNTER;    		// set TIMEOUT
    *  status_byte_clock |= (1<<7);		// start TIMEOUT
    *  _delay_ms(150);
    *  status_button=0;			//all buttons reset
    */
   
   
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   _MATRIX_CLEAR();
   status_button=0;			//all buttons reset
   _beep();
   
   //ziffer a
   ziffer_load(10, 0  ,1);
   
   
   //point dot
   matrix[8] |= (1 << 11);
   matrix[12] |= (1 << 11);
   
   while (! (status_menuset &(1<<7)))
   {
     //set alarm nr.----------------
     if (status_menuset&(1<<0))
     {
       if (temp_alnr_std_min[0] > 6){temp_alnr_std_min[0] = 0;}
       
       ziffer_load( temp_alnr_std_min[0]+11 ,  4,blink[0]);
       
       temp_alnr_std_min[1]=alarm_std[temp_alnr_std_min[0]];
       temp_alnr_std_min[2]=alarm_min[temp_alnr_std_min[0]];
       
       status_menuset &=~(1<<0); 
       status_menuset |=(1<<1); 
       status_menuset |=(1<<2); 
       
     }
     
     //set std------------------------
     if (status_menuset&(1<<1))
     {
       if (temp_alnr_std_min[1] > 23){temp_alnr_std_min[1] = 0;}
       
       
       //mod 12/24
       if (status_byte_clock&(1<<5))
       {
	 hour12std =((temp_alnr_std_min[1]+11)%12)+1;
	 
	 //when the first ziffer has the value 0 then hide the first ziffer 
	 if ( (hour12std/10) < 1){ ziffer_load( hour12std /10, 9 ,0); }else{ ziffer_load( hour12std /10,  9 ,blink[1]);}
	 
	 //second ziffer
	 ziffer_load( hour12std %10,  14 ,blink[1]);
	 
	 //pointer 12/24 mod
	 if (temp_alnr_std_min[1] > 11 && (status_byte_clock&(1<<5)) ) {matrix[6] |= (1 << 6);}else{matrix[6] &= ~(1 << 6);}  
	 
       }else{
	 
	 
	 //modus 24
	 ziffer_load(temp_alnr_std_min[1] / 10,   9,blink[1]);
	 ziffer_load(temp_alnr_std_min[1] % 10,  14,blink[1]);
	 status_menuset &=~(1<<1); 
       }     
       
       
     }
     
     //set min------------------
     if (status_menuset&(1<<2))
     {
       if (temp_alnr_std_min[2] > 59){temp_alnr_std_min[2] = 0;}
       
       ziffer_load(temp_alnr_std_min[2] / 10,  21,blink[2]);
       ziffer_load(temp_alnr_std_min[2] % 10,  26,blink[2]);
       status_menuset &=~(1<<2); 
     }
     
     
     
     if ( button3_count_cycle > 10 ){_delay_ms(100);button3_count_cycle=11;}else{_delay_ms(350); }
     
     if ( status_button&(1<<5) && (!(status_button&(1<<4))) ) {button3_count_cycle=0; status_button=0;}             
     if ( status_button&(1<<4) && (!(status_button&(1<<5))) ) {status_button=0;}
     //reset button 3 
     
     SKIP = 8;
     //wait until a button is pressed
     while ( (!(status_button &(1<<3))) && (!(status_button &(1<<4))) && SKIP );  
     if  ( TIMEOUT < 1 ) {return;}
     
     
     //toggle blink digit ------------------------------------------------------------------------------------------------------
     if (SKIP<1)
     {
       if (status_menuset &(1<<3)){ blink[choice]=1; status_menuset &=~(1<<3);}else{blink[choice]=0; status_menuset |= (1<<3); }
       // toggle the blink variable
     }
     
     if (status_button&(1<<4))
     {
       temp_alnr_std_min[choice]++;
       TIMEOUT= TIMEOUTCOUNTER;
       blink[choice]=1;
       _beep();
       
       if ( status_button &(1<<4) && status_button &(1<<5) )
       {
	 button3_count_cycle++;   
       }  
     }
     
     // when the bottom 2 was pressed prepare to go the next digit and reset all button
     if (status_button&(1<<3) && (!( status_button&(1<<2))))  
     {
       _beep();
       choice++; 
       
       status_button=0; 
       TIMEOUT= TIMEOUTCOUNTER;
       
       if (choice == 1){status_menuset |=(1<<0);status_menuset |=(1<<1);blink[0]=1;blink[1]=0;}
       if (choice == 2){status_menuset |=(1<<1);status_menuset |=(1<<2);blink[1]=1;blink[2]=0;}
       
     }else{
       
       if (choice == 0){status_menuset |=(1<<0);}
       if (choice == 1){status_menuset |=(1<<1);}
       if (choice == 2){status_menuset |=(1<<2);}     
     }
     
     //prepare to leave the loop "while (! (status_menuset &(1<<7)))"
     if(choice > 2){status_menuset = (1<<7);}
     
   }
   
   //write alarm time -------------------------------------------------------------------------------------------------------------------
   _MATRIX_CLEAR();
   alarm_std[temp_alnr_std_min[0]] = temp_alnr_std_min[1];
   alarm_min[temp_alnr_std_min[0]] = temp_alnr_std_min[2];
   
   
   //Write RTC Alarm ---------------------------------------
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     ADRESS_RTC = temp_alnr_std_min[0]*2;
     _RTC_DS1307_Read_Write_init (0x08 + ADRESS_RTC ,0 ); //start at address 0x08 
     _I2C_Write_data (temp_alnr_std_min[1],0); //write std
     _I2C_Write_data (temp_alnr_std_min[2],1); //write min
   }  
   //------------------------------------------------------   
   
   status_button|=(1 << 3); 
 }
 
 
 
 void _time_set(void)
 {
   uint8_t temp_std_min_sec[3];
   uint8_t button3_count_cycle=0;
   uint8_t blink[3]={1,1,1};         	//let the digit blink (0=hide,1=show)
   uint8_t choice=0;
   
   
   uint8_t status_menuset=0b00000111;
   //status_menuset = (1<<0) = show std 
   //status_menuset = (1<<1) = show min 
   //status_menuset = (1<<2) = show sec  
   //status_menuset = (1<<3) = toggle blink
   //status_menuset = (1<<7) = leave loop  
   
   temp_std_min_sec[0]=t_std;
   temp_std_min_sec[1]=t_min;
   temp_std_min_sec[2]=t_sec;
   
   /*
    *  TIMEOUT= TIMEOUTCOUNTER;    		// set TIMEOUT
    *  status_byte_clock |= (1<<7);		// start TIMEOUT
    *  _delay_ms(150);
    *  status_button=0;			//all buttons reset
    */
   
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   _MATRIX_CLEAR();
   status_button=0;			//all buttons reset
   _beep();
   
   
   //point dot
   matrix[1] |= (1 << 5);
   matrix[5] |= (1 << 5);
   
   while (! (status_menuset &(1<<7)))
   {
     
     //set std------------------------
     if (status_menuset&(1<<0))
     {
       if (temp_std_min_sec[0] > 23){temp_std_min_sec[0] = 0;}
       
       //mod 12/24
       if (status_byte_clock&(1<<5))
       {
	 hour12std =((temp_std_min_sec[0]+11)%12)+1;
	 
	 //when the first ziffer has the value 0 then hide the first ziffer 
	 if ( (hour12std/10) < 1) {ziffer_load( hour12std /10,  0 ,0);}else{ziffer_load( hour12std /10,  0 ,blink[0]);}
	 
	 //second ziffer
	 ziffer_load( hour12std %10,  5 ,blink[0]);
	 
	 //pointer 12/24 mod
	 if (temp_std_min_sec[0] > 11 && (status_byte_clock&(1<<5)) ) {matrix[6] |= (1 << 15);}else{matrix[6] &= ~(1 << 15);}    
	 
       }else{
	 
	 //modus 24
	 ziffer_load(temp_std_min_sec[0] / 10,  0,blink[0]);
	 ziffer_load(temp_std_min_sec[0] % 10,  5,blink[0]);
       }
       
       
       
       status_menuset &=~(1<<0); 
     }
     
     //set min------------------
     if (status_menuset&(1<<1))
     {
       if (temp_std_min_sec[1] > 59){temp_std_min_sec[1] = 0;}
       
       ziffer_load(temp_std_min_sec[1] / 10,  12,blink[1]);
       ziffer_load(temp_std_min_sec[1] % 10,  17,blink[1]);
       status_menuset &=~(1<<1); 
     }
     
     //set sec-------------------
     if (status_menuset&(1<<2))
     {
       if (temp_std_min_sec[2] > 59){temp_std_min_sec[2] = 0;}
       
       ziffer_load_small(temp_std_min_sec[2] / 10,  23,blink[2]);
       ziffer_load_small(temp_std_min_sec[2] % 10,  27,blink[2]);
       status_menuset &=~(1<<2); 
     }
     
     
     if ( button3_count_cycle > 10 ){_delay_ms(100);button3_count_cycle=11;}else{_delay_ms(350); }
     
     if ( status_button&(1<<5) && (!(status_button&(1<<4))) ) {button3_count_cycle=0; status_button=0;}             
     if ( status_button&(1<<4) && (!(status_button&(1<<5))) ) {status_button=0;}
     //reset button 3 
     
     SKIP = 8;
     //wait until a button is pressed
     while ( (!(status_button &(1<<3))) && (!(status_button &(1<<4))) && SKIP );  
     if  ( TIMEOUT < 1 ) {return;}
     
     
     //toggle blink digit ------------------------------------------------------------------------------------------------------
     if (SKIP<1)
     {
       if (status_menuset &(1<<3)){ blink[choice]=1; status_menuset &=~(1<<3);}else{blink[choice]=0; status_menuset |= (1<<3); }
       // toggle the blink variable
     }
     
     if (status_button&(1<<4))
     {
       temp_std_min_sec[choice]++;
       TIMEOUT= TIMEOUTCOUNTER;
       blink[choice]=1;
       _beep();
       
       if ( status_button &(1<<4) && status_button &(1<<5) )
       {
	 button3_count_cycle++;   
       }  
     }
     
     // when the bottom 2 was pressed prepare to go the next digit and reset all button
     if (status_button&(1<<3) && (!( status_button&(1<<2))))  
     {
       _beep();
       choice++; 
       //_delay_ms(150);
       status_button=0; 
       TIMEOUT= TIMEOUTCOUNTER;
       
       if (choice == 1){status_menuset |=(1<<0);status_menuset |=(1<<1);blink[0]=1;blink[1]=0;}
       if (choice == 2){status_menuset |=(1<<1);status_menuset |=(1<<2);blink[1]=1;blink[2]=0;}
       
     }else{
       
       if (choice == 0){status_menuset |=(1<<0);}
       if (choice == 1){status_menuset |=(1<<1);}
       if (choice == 2){status_menuset |=(1<<2);}     
     }
     
     //prepare to leave the loop "while (! (status_menuset &(1<<7)))"
     if(choice > 2){status_menuset = (1<<7);}
     
   }
   
   //write time -------------------------------------------------------------------------------------------------------------------
   _MATRIX_CLEAR();
   t_std=temp_std_min_sec[0];
   t_min=temp_std_min_sec[1];
   t_sec=temp_std_min_sec[2];
   
   //Write RTC---------------------------------------------
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     _RTC_DS1307_Read_Write_init (0x00, 0 );//Start Adresse 00 (sec), Read_Write  Read = 1 , Write = 0
     
     temp_std_min_sec[2] = _Binary_to_BCD2Digit(temp_std_min_sec[2]);
     _I2C_Write_data (temp_std_min_sec[2],0); 
     
     temp_std_min_sec[1] = _Binary_to_BCD2Digit(temp_std_min_sec[1]);
     _I2C_Write_data (temp_std_min_sec[1],0);
     
     temp_std_min_sec[0] = _Binary_to_BCD2Digit(temp_std_min_sec[0]);
     _I2C_Write_data (temp_std_min_sec[0],1);
   }
   //Ende Write RTC-----------------------------------------
   
   status_button|=(1 << 3);
   
 }
 
 
 
 void  _screen_set(void)
 {
   uint8_t temp_screen_12mod_sec[3];
   uint8_t button3_count_cycle=0;
   uint8_t blink[3]={1,1,1};         	//let the digit blink (0=hide,1=show)
   uint8_t choice=0;
   
   
   uint8_t status_menuset=0b00000001;
   //status_menuset = (1<<0) = show screen mod date,time,alarm
   //status_menuset = (1<<1) = show 12 or 24 mod
   //status_menuset = (1<<2) = show sec on or off  
   //status_menuset = (1<<3) = toggle blink
   //status_menuset = (1<<7) = leave loop  
   
   temp_screen_12mod_sec[0]=screen;
   
   //zuweisen 
   if (status_byte_clock&(1 << 5)){ temp_screen_12mod_sec[1]=0; }else{  temp_screen_12mod_sec[1]=1;  } //12 or 24 modus
   if (status_byte_clock&(1 << 2)){ temp_screen_12mod_sec[2]=1; }else{  temp_screen_12mod_sec[2]=0;  } //second
   
   /* 
    *  TIMEOUT= TIMEOUTCOUNTER;    		// set TIMEOUT
    *  status_byte_clock |= (1<<7);		// start TIMEOUT
    *  _delay_ms(150);
    *  status_button=0;			//all buttons reset
    */
   
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   _MATRIX_CLEAR();
   status_button=0;			//all buttons reset
   _beep();
   
   _alphabet_load(27,0,1);//symbol " > "
   
   while (! (status_menuset &(1<<7)))
   {
     //set screen------------------
     if (status_menuset&(1<<0))
     {
       if (temp_screen_12mod_sec[0] > 3){temp_screen_12mod_sec[0] = 1;}
       
       _alphabet_load(space, 5,blink[0]);
       _alphabet_load(space,10,blink[0]);
       _alphabet_load(space,15,blink[0]);
       _alphabet_load(space,20,blink[0]);
       _alphabet_load(space,25,blink[0]);
       
       _menu_titel(temp_screen_12mod_sec[0],4,blink[0]);
       
       status_menuset &=~(1<<0); 
     }
     
     
     //set mod 12std 24std
     if (status_menuset&(1<<1))
     { 
       
       if (temp_screen_12mod_sec[1] > 1){temp_screen_12mod_sec[1] = 0;}
       
       ziffer_load( (temp_screen_12mod_sec[1]*12+12) / 10,  20,blink[1]);
       ziffer_load( (temp_screen_12mod_sec[1]*12+12) % 10,  25,blink[1]);
       
       status_menuset &=~(1<<1); 
     }
     
     //set sec on off-------------------
     if (status_menuset&(1<<2))
     {
       if (temp_screen_12mod_sec[2] > 1){temp_screen_12mod_sec[2] = 0;} // on=1 or off=0
       
       _alphabet_load(space, 26 ,blink[2]);
       _menu_titel( temp_screen_12mod_sec[2]+12, 16 ,blink[2]);
       
       status_menuset &=~(1<<2); 
     }
     
     
     if ( button3_count_cycle > 10 ){_delay_ms(100);button3_count_cycle=11;}else{_delay_ms(350); }
     
     if ( status_button&(1<<5) && (!(status_button&(1<<4))) ) {button3_count_cycle=0; status_button=0;}             
     if ( status_button&(1<<4) && (!(status_button&(1<<5))) ) {status_button=0;}
     //reset button 3 
     
     SKIP = 8;
     //wait until a button is pressed
     while ( (!(status_button &(1<<3))) && (!(status_button &(1<<4))) && SKIP );  
     if  ( TIMEOUT < 1 ) {return;}
     
     
     //toggle blink digit ------------------------------------------------------------------------------------------------------
     if (SKIP<1)
     {
       if (status_menuset &(1<<3)){ blink[choice]=1; status_menuset &=~(1<<3);}else{blink[choice]=0; status_menuset |= (1<<3); }
       // toggle the blink variable
     }
     
     if (status_button&(1<<4))
     {
       temp_screen_12mod_sec[choice]++;
       TIMEOUT= TIMEOUTCOUNTER;
       blink[choice]=1;
       _beep();
       
       if ( status_button &(1<<4) && status_button &(1<<5) )
       {
	 button3_count_cycle++;   
       }  
     }
     
     // when the bottom 2 was pressed prepare to go the next digit and reset all button
     if (status_button&(1<<3) && (!( status_button&(1<<2))))  
     {
       _beep();
       choice++; 
       //_delay_ms(150);
       status_button=0; 
       TIMEOUT= TIMEOUTCOUNTER;
       
       if (choice == 1){status_menuset |=(1<<1);blink[1]=1;_MATRIX_CLEAR();_menu_titel(14,0,1);}
       if (choice == 2){status_menuset |=(1<<2);blink[2]=1;_MATRIX_CLEAR();_menu_titel(15,0,1);}
       
     }else{
       
       if (choice == 0){status_menuset |=(1<<0);}
       if (choice == 1){status_menuset |=(1<<1);}
       if (choice == 2){status_menuset |=(1<<2);}     
     }
     
     //prepare to leave the loop "while (! (status_menuset &(1<<7)))"
     if(choice > 2){status_menuset = (1<<7);}
     
   }
   
   //write time -------------------------------------------------------------------------------------------------------------------
   _MATRIX_CLEAR();
   screen=temp_screen_12mod_sec[0];
   if (screen == 3){  alarm_status &=~(1<<0);}
   if (temp_screen_12mod_sec[1]<1 ){ status_byte_clock |=(1 << 5); }else{ status_byte_clock &=~(1 << 5); }
   
   if (temp_screen_12mod_sec[2] < 1)
   {
     status_byte_clock &=~(1 << 2); // set off
     
   }else{
     
     status_byte_clock |= (1 << 2); // set on    
   }
   
   
   //RTC Write Screen Settings ------------------------------------------
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     _RTC_DS1307_Read_Write_init (0x19 ,0 ); //start at address 19 or in dez 25
     _I2C_Write_data (screen           ,0); //write screen     
     _I2C_Write_data (status_byte_clock,1); //write status_byte_clock  
   } 
   
   status_button|=(1 << 3); 
 }
 
 
 void  _ring_set(void)
 {
   uint8_t button3_count_cycle=0;
   uint8_t blink=1;         	//let the digit blink (0=hide,1=show)
   uint8_t menu_pointer[3]={21,22,23}; //21 = single , 22 = mixed ,23 = multi 
   
   
   uint8_t status_menuset=0b00000001;
   //status_menuset = (1<<0) = show option
   //status_menuset = (1<<1) = 
   //status_menuset = (1<<2) =  
   //status_menuset = (1<<3) = toggle blink
   //status_menuset = (1<<7) = leave loop  
   
   
   
   
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   _MATRIX_CLEAR();
   _beep();
   status_button=0;			//all buttons reset
   
   _alphabet_load(27,0,1);//symbol " > "
   
   while (! (status_menuset &(1<<7)))
   {
     
     
     //set ring ------------------
     
     if (ring_set > 2){ring_set = 0;}
     
     _alphabet_load(space, 5,blink);
     _alphabet_load(space,10,blink);
     _alphabet_load(space,15,blink);
     _alphabet_load(space,20,blink);
     _alphabet_load(space,25,blink);
     
     _menu_titel(menu_pointer[ring_set],4,blink);
     
     
     if ( button3_count_cycle > 10 ){_delay_ms(100);button3_count_cycle=11;}else{_delay_ms(350); }
     
     if ( status_button&(1<<5) && (!(status_button&(1<<4))) ) {button3_count_cycle=0; status_button=0;}             
     if ( status_button&(1<<4) && (!(status_button&(1<<5))) ) {status_button=0;}
     //reset button 3 
     
     SKIP = 8;
     //wait until a button is pressed
     while ( (!(status_button &(1<<3))) && (!(status_button &(1<<4))) && SKIP );  
     if  ( TIMEOUT < 1 ) {return;}
     
     
     //toggle blink digit ------------------------------------------------------------------------------------------------------
     if (SKIP<1)
     {
       if (status_menuset &(1<<3)){ blink=1; status_menuset &=~(1<<3);}else{blink=0; status_menuset |= (1<<3); }
       // toggle the blink variable
     }
     
     if (status_button&(1<<4))
     {
       ring_set++;
       TIMEOUT= TIMEOUTCOUNTER;
       blink=1;
       _beep();
       
       if ( status_button &(1<<4) && status_button &(1<<5) )
       {
	 button3_count_cycle++;   
       }  
     }
     
     // when the bottom 2 was pressed prepare to go the next digit and reset all button
     if (status_button&(1<<3) && (!( status_button&(1<<2))))  
     {
       _beep();
       
       status_button=0; 
       TIMEOUT= TIMEOUTCOUNTER;
       
       status_menuset = (1<<7);//prepare to leave the loop "while (! (status_menuset &(1<<7)))"    
     }
   }
   // -------------------------------------------------------------------------------------------------------------------
   
   
   //RTC write sensor setting  ----------------------------------
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     _RTC_DS1307_Read_Write_init (0x1F ,0 ); //start at address 1F or in dez 31
     _I2C_Write_data (ring_set,1); //write ring mod
   } 
   //-----------------------------------------------------------   
   
   
   
   _MATRIX_CLEAR();
   status_button|=(1 << 3); 
 }
 
 
 
 void _bright_set(void)
 
 {
   uint8_t button3_count_cycle=0;
   uint8_t blink[4]={1,1,1,1};         	//let the digit blink (0=hide,1=show)
   uint8_t choice=0;
   uint8_t count[4]={0,0,0,0};
   
   
   uint8_t status_menuset=0b00001111;
   //status_menuset = (1<<0) = show R
   //status_menuset = (1<<1) = show G
   //status_menuset = (1<<2) = show B 
   //status_menuset = (1<<3) = show M
   //status_menuset = (1<<4) =
   //status_menuset = (1<<5) =
   //status_menuset = (1<<6) = toggle blink
   //status_menuset = (1<<7) = leave loop  
   
   
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   _MATRIX_CLEAR();
   _LED_CLEAR();
   _beep();
   
   //set red green blue------------------
   _12LED_SET ( 0,PCB_PIN_COLOR_RED,0);//red
   _12LED_SET (11,PCB_PIN_COLOR_GREEN,0);//green
   _12LED_SET (10,PCB_PIN_COLOR_BLUE,0);//blue
   
   
   count[0]=  RGBM_Bright[PCB_PIN_COLOR_RED]      ;
   count[1]=  RGBM_Bright[PCB_PIN_COLOR_GREEN]    ;
   count[2]=  RGBM_Bright[PCB_PIN_COLOR_BLUE]     ;
   count[3]=  RGBM_Bright[3]      ;
   
   
   
   status_button=0;			//all buttons reset 
   
   while (! (status_menuset &(1<<7)))
   {
     
     if (status_menuset&(1<<0))
     {
       
       if (count[choice]>9){count[choice]=0;}
       
       _ONE_RGB_BRIGHT(PCB_PIN_COLOR_RED,count[0]); //red  
       _alphabet_load(r,0,blink[0]);
       
       status_menuset &=~(1<<0);  
     }
     
     
     if (status_menuset&(1<<1))
     {
       if (count[choice]>9){count[1]=0;}
       
       _ONE_RGB_BRIGHT(PCB_PIN_COLOR_GREEN,count[1]); //green 
       _alphabet_load(g,5,blink[1]);
       
       status_menuset &=~(1<<1);  
     }
     
     
     if (status_menuset&(1<<2))
     {
       if (count[choice]>9){count[choice]=0;}
       
       _ONE_RGB_BRIGHT(PCB_PIN_COLOR_BLUE,count[2]); //blue
       _alphabet_load(b,10,blink[2]);
       
       status_menuset &=~(1<<2);   
     }
     
     if (status_menuset&(1<<3))
     {
       if (count[choice]>9){count[choice]=0;}
       
       _ONE_RGB_BRIGHT(3,count[3]); //matrix
       _alphabet_load(m,15,blink[3]);
       
       status_menuset &=~(1<<3);   
     }
     
     
     if ( count[choice] < 1)
     {
       _alphabet_load( l, 25, blink[choice] );
       
     }else{  
       ziffer_load(count[choice],25,blink[choice]);
       
       
     }
     
     if ( button3_count_cycle > 10 ){_delay_ms(100);button3_count_cycle=11;}else{_delay_ms(350); }
     
     if ( status_button&(1<<5) && (!(status_button&(1<<4))) ) {button3_count_cycle=0; status_button=0;}             
     if ( status_button&(1<<4) && (!(status_button&(1<<5))) ) {status_button=0;}
     //reset button 3 
     
     SKIP = 8;
     //wait until a button is pressed
     while ( (!(status_button &(1<<3))) && (!(status_button &(1<<4))) && SKIP );  
     if  ( TIMEOUT < 1 ) {return;}
     
     
     //toggle blink digit ------------------------------------------------------------------------------------------------------
     if (SKIP<1)
     {
       if (status_menuset &(1<<6)){ blink[choice]=1; status_menuset &=~(1<<6);}else{blink[choice]=0; status_menuset |= (1<<6); }
       // toggle the blink variable
     }
     
     if (status_button&(1<<4))
     {
       count[choice]++;
       
       TIMEOUT= TIMEOUTCOUNTER;
       blink[choice]=1;
       _beep();
       
       if ( status_button &(1<<4) && status_button &(1<<5) )
       {
	 button3_count_cycle++;   
       }  
     }
     
     if (status_button&(1<<3) && (!( status_button&(1<<2))))  
     {
       _beep();
       choice++; 
       
       status_button=0; 
       TIMEOUT= TIMEOUTCOUNTER;
       
       if (choice == 1){status_menuset |=(1<<0);status_menuset |=(1<<1);blink[0]=1;blink[1]=0;   }
       if (choice == 2){status_menuset |=(1<<1);status_menuset |=(1<<2);blink[1]=1;blink[2]=0;   }
       if (choice == 3){status_menuset |=(1<<2);status_menuset |=(1<<3);blink[2]=1;blink[3]=0;   }
       
     }else{
       
       if (choice == 0){status_menuset |=(1<<0);}
       if (choice == 1){status_menuset |=(1<<1);}
       if (choice == 2){status_menuset |=(1<<2);}     
       if (choice == 3){status_menuset |=(1<<3);}
       
     }
     
     //prepare to leave the loop "while (! (status_menuset &(1<<7)))"
     if(choice > 3){status_menuset = (1<<7);}
   }
   
   
   //------------------------------------------------------------------------
   
   RGBM_Bright[PCB_PIN_COLOR_RED]   =  count[0];
   RGBM_Bright[PCB_PIN_COLOR_GREEN] =  count[1];
   RGBM_Bright[PCB_PIN_COLOR_BLUE]  =  count[2];
   RGBM_Bright[3]   =  count[3];
   
   sensor_set&=~(1<<0);  // Auto bright adjust off
   
   
   //RTC Write RGBM_Bright ------------------------------------------
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     _RTC_DS1307_Read_Write_init (0x1B ,0 ); //start at address 1B or in dez 27
     _I2C_Write_data (RGBM_Bright[0],0); //write RGBM_Bright 
     _I2C_Write_data (RGBM_Bright[1],0); //write RGBM_Bright 
     _I2C_Write_data (RGBM_Bright[2],0); //write RGBM_Bright 
     _I2C_Write_data (RGBM_Bright[3],1); //write RGBM_Bright matrix     
   
     //sensor Auto bright adjust off
     _RTC_DS1307_Read_Write_init (0x18 ,0 ); //start at address 18 or in dez 24
     _I2C_Write_data (sensor_set,1); //write sensor setting 
  } 
   //-----------------------------------------------------------------
   
   _MATRIX_CLEAR();
   status_button|=(1 << 3);
 }
 
 
 void _glow_set(void)
 { 
   uint8_t on_off = 0;
   uint8_t button3_count_cycle=0;
   uint8_t blink=1;         	//let the digit blink (0=hide,1=show)
   
   if ( alarm_status &(1<<5) ) {on_off=1;}
   
   uint8_t status_menuset=0b00000001;
   //status_menuset = (1<<0) = show option
   //status_menuset = (1<<1) = 
   //status_menuset = (1<<2) =  
   //status_menuset = (1<<3) = toggle blink
   //status_menuset = (1<<7) = leave loop  
   
   
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   _MATRIX_CLEAR();
   _beep();
   status_button=0;			//all buttons reset 
   
   _alphabet_load(27,0,1);//symbol " > "
   
   
   while (! (status_menuset &(1<<7)))
   {
     //set glow------------------
     if (on_off > 1) { on_off = 0;}
     
     _alphabet_load(space, 14 ,blink);
     _menu_titel( on_off+12, 4 ,blink);
     
     
     if ( button3_count_cycle > 10 ){_delay_ms(100);button3_count_cycle=11;}else{_delay_ms(350); }
     
     if ( status_button&(1<<5) && (!(status_button&(1<<4))) ) {button3_count_cycle=0; status_button=0;}             
     if ( status_button&(1<<4) && (!(status_button&(1<<5))) ) {status_button=0;}
     //reset button 3 
     
     SKIP = 8;
     //wait until a button is pressed
     while ( (!(status_button &(1<<3))) && (!(status_button &(1<<4))) && SKIP );  
     if  ( TIMEOUT < 1 ) {return;}
     
     
     //toggle blink digit ------------------------------------------------------------------------------------------------------
     if (SKIP<1)
     {
       if (status_menuset &(1<<3)){ blink=1; status_menuset &=~(1<<3);}else{blink=0; status_menuset |= (1<<3); }
       // toggle the blink variable
     }
     
     if (status_button&(1<<4))
     {
       on_off++;
       TIMEOUT= TIMEOUTCOUNTER;
       blink=1;
       _beep();
       
       if ( status_button &(1<<4) && status_button &(1<<5) )
       {
	 button3_count_cycle++;   
       }  
     }
     
     // when the bottom 2 was pressed prepare to go the next digit and reset all button
     if (status_button&(1<<3) && (!( status_button&(1<<2))))  
     {
       _beep();
       
       status_button=0; 
       TIMEOUT= TIMEOUTCOUNTER;
       
       status_menuset = (1<<7);//prepare to leave the loop "while (! (status_menuset &(1<<7)))"
       
     }
     
     
   }
   // write glow on on_off
   
   if (on_off < 1)
   {
     alarm_status &=~(1 << 5); // set off
     
   }else{
     
     alarm_status |= (1 << 5); // set on    
   }
   
   //RTC write glow setting  ----------------------------------
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     _RTC_DS1307_Read_Write_init (0x17 ,0 ); //start at address 17 or in dez 23
     _I2C_Write_data (alarm_status,1); //write glow setting
   } 
   //-----------------------------------------------------------   
   
   _MATRIX_CLEAR();
   status_button|=(1 << 3);
 }
 
 void _sensor_set(void)
 
 {
   uint8_t button3_count_cycle=0;
   uint8_t blink[2]={1,1};         	//let the digit blink (0=hide,1=show)
   uint8_t choice=0;
   uint8_t count[2]={0,0};
   
   uint8_t menu_pointer[4]={12,18,12,24}; //12 = off , 18 = dim ,12 = off ,24 = wake
   
   uint8_t status_menuset=0b00000001;
   //status_menuset = (1<<0) = show OFF, DIM
   //status_menuset = (1<<1) = show OFF, WAKE
   //status_menuset = (1<<2) =  
   //status_menuset = (1<<3) = 
   //status_menuset = (1<<4) =
   //status_menuset = (1<<5) =
   //status_menuset = (1<<6) = toggle blink
   //status_menuset = (1<<7) = leave loop  
   
   
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   _MATRIX_CLEAR();
   _beep();
   status_button=0;			//all buttons reset
   
   _alphabet_load(27,0,1);//symbol " > "
   
   //assign sensor values
   if (sensor_set&(1<<0)){count[0]=1;}	//sensor(1<<0) , 0 = OFF, 1 = DIM
   if (sensor_set&(1<<1)){count[1]=1;}	//sensor(1<<1) , 0 = OFF, 1 = WAKE
   
   
   
   status_button=0;			//all buttons reset 
   
   while (! (status_menuset &(1<<7)))
   {
     
     if (status_menuset&(1<<0))
     {
       
       if (count[choice]>1){count[choice]=0;}
       
       _alphabet_load(space,15,blink[choice]);
       
       _menu_titel(menu_pointer[count[0]] ,4,blink[choice]);
       
       status_menuset &=~(1<<0);  
     }
     
     
     if (status_menuset&(1<<1))
     {
       if (count[choice]>1){count[1]=0;}
       _alphabet_load(space,11,blink[choice]);
       _alphabet_load(space,23,blink[choice]);
       
       _menu_titel(menu_pointer[ count[1]+2 ],7,blink[choice]);
       
       status_menuset &=~(1<<1);  
     }
     
     
     
     if ( button3_count_cycle > 10 ){_delay_ms(100);button3_count_cycle=11;}else{_delay_ms(350); }
     
     if ( status_button&(1<<5) && (!(status_button&(1<<4))) ) {button3_count_cycle=0; status_button=0;}             
     if ( status_button&(1<<4) && (!(status_button&(1<<5))) ) {status_button=0;}
     //reset button 3 
     
     SKIP = 8;
     //wait until a button is pressed
     while ( (!(status_button &(1<<3))) && (!(status_button &(1<<4))) && SKIP );  
     if  ( TIMEOUT < 1 ) {return;}
     
     
     //toggle blink digit ------------------------------------------------------------------------------------------------------
     if (SKIP<1)
     {
       if (status_menuset &(1<<6)){ blink[choice]=1; status_menuset &=~(1<<6);}else{blink[choice]=0; status_menuset |= (1<<6); }
       // toggle the blink variable
     }
     
     if (status_button&(1<<4))
     {
       count[choice]++;
       
       TIMEOUT= TIMEOUTCOUNTER;
       blink[choice]=1;
       _beep();
       
       if ( status_button &(1<<4) && status_button &(1<<5) )
       {
	 button3_count_cycle++;   
       }  
     }
     
     if (status_button&(1<<3) && (!( status_button&(1<<2))))  
     {
       _beep();
       choice++; 
       
       status_button=0; 
       TIMEOUT= TIMEOUTCOUNTER;
       
       if (choice == 1){status_menuset |=(1<<1);blink[1]=1; _alphabet_load(27,3,1); /*symbol " > "*/   }
       
     }else{
       
       if (choice == 0){status_menuset |=(1<<0);}
       if (choice == 1){status_menuset |=(1<<1);}
       
     }
     
     //prepare to leave the loop "while (! (status_menuset &(1<<7)))"
     if(choice > 1){status_menuset = (1<<7);}
   }
   
   
   //------------------------------------------------------------------------
   
   
   //assign sensor values
   sensor_set=0b00000000;
   if (count[0] > 0 ){sensor_set |= (1<<0);}	//sensor(1<<0) , 0 = OFF, 1 = DIM
   if (count[1] > 0 ){sensor_set |= (1<<1);}	//sensor(1<<1) , 0 = OFF, 1 = WAKE
   
   
   //RTC write sensor setting  ----------------------------------
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     _RTC_DS1307_Read_Write_init (0x18 ,0 ); //start at address 18 or in dez 24
     _I2C_Write_data (sensor_set,1); //write sensor setting 
   } 
   //----------------------------------------------------------- 
   
   _MATRIX_CLEAR();
   status_button|=(1 << 3);
 }
 
 
 
 void _beep_set(void)
 { 
   uint8_t on_off = 0;
   uint8_t button3_count_cycle=0;
   uint8_t blink=1;         	//let the digit blink (0=hide,1=show)
   
   if ( status_byte_clock &(1<<1) ) {on_off=1;}
   
   uint8_t status_menuset=0b00000001;
   //status_menuset = (1<<0) = show option
   //status_menuset = (1<<1) = 
   //status_menuset = (1<<2) =  
   //status_menuset = (1<<3) = toggle blink
   //status_menuset = (1<<7) = leave loop  
   
   
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   _MATRIX_CLEAR();
   _beep();
   status_button=0;			//all buttons reset 
   
   _alphabet_load(27,0,1);//symbol " > "
   
   
   while (! (status_menuset &(1<<7)))
   {
     //set glow------------------
     if (on_off > 1) { on_off = 0;}
     
     _alphabet_load(space, 14 ,blink);
     _menu_titel( on_off+12, 4 ,blink);
     
     
     if ( button3_count_cycle > 10 ){_delay_ms(100);button3_count_cycle=11;}else{_delay_ms(350); }
     
     if ( status_button&(1<<5) && (!(status_button&(1<<4))) ) {button3_count_cycle=0; status_button=0;}             
     if ( status_button&(1<<4) && (!(status_button&(1<<5))) ) {status_button=0;}
     //reset button 3 
     
     SKIP = 8;
     //wait until a button is pressed
     while ( (!(status_button &(1<<3))) && (!(status_button &(1<<4))) && SKIP );  
     if  ( TIMEOUT < 1 ) {return;}
     
     
     //toggle blink digit ------------------------------------------------------------------------------------------------------
     if (SKIP<1)
     {
       if (status_menuset &(1<<3)){ blink=1; status_menuset &=~(1<<3);}else{blink=0; status_menuset |= (1<<3); }
       // toggle the blink variable
     }
     
     if (status_button&(1<<4))
     {
       on_off++;
       TIMEOUT= TIMEOUTCOUNTER;
       blink=1;
       _beep();
       
       if ( status_button &(1<<4) && status_button &(1<<5) )
       {
	 button3_count_cycle++;   
       }  
     }
     
     // when the bottom 2 was pressed prepare to go the next digit and reset all button
     if (status_button&(1<<3) && (!( status_button&(1<<2))))  
     {
       _beep();
       
       status_button=0; 
       TIMEOUT= TIMEOUTCOUNTER;
       
       status_menuset = (1<<7);//prepare to leave the loop "while (! (status_menuset &(1<<7)))"
       
     }
     
     
   }
   // write beep on on_off
   
   if (on_off < 1)
   {
     status_byte_clock &=~(1 << 1); // set off
     
   }else{
     
     status_byte_clock |= (1 << 1); // set on    
   }
   
   //RTC write beep setting  ----------------------------------
   if (!(status_byte_clock &(1<<3))) //if device mounted  "status_byte_clock &(1<<3) = 0" then write the settings to ram
   {
     _RTC_DS1307_Read_Write_init (0x1A ,0 ); //start at address 1A or in dez 26
     _I2C_Write_data (status_byte_clock,1); //write beep modus
   } 
   //-----------------------------------------------------------   
   
   _MATRIX_CLEAR();
   status_button|=(1 << 3);
 }
 
 
 void _info(void)
 { 
   while (  ((!(status_button &(1<<3))) || status_button &(1<<2)) && (!(status_button &(1<<1))) && TIMEOUT );
   
   if  (status_button &(1<<1) || TIMEOUT < 1 ){return;}
   
   _beep();
   status_button=0;			//all buttons reset
   
   matrix[0 ]=0b1110011100101000 ; matrix[7 ]=0b1011101110000000 ;
   matrix[1 ]=0b1001010010101000 ; matrix[8 ]=0b1010001001000000 ;
   matrix[2 ]=0b1001010010101000 ; matrix[9 ]=0b1010001001000000 ;
   matrix[3 ]=0b1001011100101000 ; matrix[10]=0b1011101110000000 ;
   matrix[4 ]=0b1001010100101000 ; matrix[11]=0b1010001010000000 ;
   matrix[5 ]=0b1001010010100100 ; matrix[12]=0b1010001001000000 ;
   matrix[6 ]=0b1110010010100010 ; matrix[13]=0b1011101001000000 ;
   
   _delay_ms(3000);
   matrix[0 ]=0b1001011101110000 ; matrix[7 ]=0b0000000100000010 ;
   matrix[1 ]=0b1001010001001000 ; matrix[8 ]=0b0000001100000110 ;
   matrix[2 ]=0b1001010001001000 ; matrix[9 ]=0b0000010100001010 ;
   matrix[3 ]=0b1001011101110000 ; matrix[10]=0b0000000100000010 ;
   matrix[4 ]=0b1001010001010000 ; matrix[11]=0b0000000100000010 ;
   matrix[5 ]=0b0101010001001000 ; matrix[12]=0b0000000100000010 ;
   matrix[6 ]=0b0010011101001010 ; matrix[13]=0b0000000101000010 ;
   
   /*
    * _delay_ms(3000);
    * matrix[0 ]=0b1000100110011100 ; matrix[7 ]=0b1110001100111000 ;
    * matrix[1 ]=0b1000101001010000 ; matrix[8 ]=0b1001010010100000 ;
    * matrix[2 ]=0b1000101000010000 ; matrix[9 ]=0b1001010000100000 ;
    * matrix[3 ]=0b1000101000011100 ; matrix[10]=0b1001010000111000 ;
    * matrix[4 ]=0b1000101000010000 ; matrix[11]=0b1001010000100000 ;
    * matrix[5 ]=0b1000101001010000 ; matrix[12]=0b1001010010100000 ;
    * matrix[6 ]=0b1110100110011100 ; matrix[13]=0b1001001100111000 ;
    * 
    * _delay_ms(3000); 
    * matrix[0 ]=0b0110000000000000 ; matrix[7 ]=0b0000001000000000 ;
    * matrix[1 ]=0b1001000001110000 ; matrix[8 ]=0b0000001010100000 ;
    * matrix[2 ]=0b1000001101000010 ; matrix[9 ]=0b0011101010101110 ;
    * matrix[3 ]=0b1000010001100100 ; matrix[10]=0b1001001010101000 ;
    * matrix[4 ]=0b1001010001000110 ; matrix[11]=0b1001001010101100 ;
    * matrix[5 ]=0b0110010001110100 ; matrix[12]=0b1001000001001000 ;
    * matrix[6 ]=0b0000010000000100 ; matrix[13]=0b1001000000001110 ;
    */
   
   _delay_ms(3000);
   matrix[0 ]=0b1000010010000000 ; matrix[7 ]=0b0000000000000000 ;
   matrix[1 ]=0b1000010010000110 ; matrix[8 ]=0b0010010100100000 ;
   matrix[2 ]=0b1110010010001000 ; matrix[9 ]=0b1010010101000000 ;
   matrix[3 ]=0b1001001110001000 ; matrix[10]=0b0010010110001110 ;
   matrix[4 ]=0b1001000010001000 ; matrix[11]=0b0011110101000000 ;
   matrix[5 ]=0b1110001100001000 ; matrix[12]=0b1010010100100000 ;
   matrix[6 ]=0b0000000000000110 ; matrix[13]=0b0010010100100000 ;
   
   
   _delay_ms(3000);
   matrix[0 ]=0b0110000000000000 ; matrix[7 ]=0b0000001000000000 ;
   matrix[1 ]=0b1001000001110000 ; matrix[8 ]=0b0000001010100000 ;
   matrix[2 ]=0b1000001101000010 ; matrix[9 ]=0b0011101010101110 ;
   matrix[3 ]=0b1000010001100100 ; matrix[10]=0b1001001010101000 ;
   matrix[4 ]=0b1001010001000110 ; matrix[11]=0b1001001010101100 ;
   matrix[5 ]=0b0110010001110100 ; matrix[12]=0b1001000001001000 ;
   matrix[6 ]=0b0000010000000100 ; matrix[13]=0b1001000000001110 ;
   
   _delay_ms(3000);
   status_button|=(1 << 3);
 }
 
 
