//RGB Colour Clock Driver alpha 1.1

//Written by Christoph Kreis
//You can change the code if you like or share it with your friends, but it's not allowed to deal with the code.



void _sound(uint8_t on_off)
{
  if (on_off > 0)
  {
    SOUND_ON;
  }
  else
  { 
    SOUND_OFF;
  }
}

void _beep(void)
{
  if ( status_byte_clock&(1 << 1) )
  {SOUND_ON;_delay_ms(4);SOUND_OFF;} 
}


uint8_t _bright_level_index (uint8_t rgbled_matrix_nr, uint8_t dim_level)
{  
  uint8_t bright_index[4][10]={ 
// Typ II
        {92,99,111,124,142,160,177,198,228,255},   //color_1 = PCB_LED_PIN_1 (red)
        {113,117,121,128,137,144,155,168,182,190}, //color_2 = PCB_LED_PIN_3 (green)
        {125,129,132,137,142,149,154,163,175,255}, //color_3 = PCB_LED_PIN_4 (blue)
        {253,248,235,212,185,150,120,80,40,0}};    //matrix
  
// Typ I
// {85,92,110,124,142,160,177,198,228,255},    //color_3 = PCB_LED_PIN_4 (red)
// {{126,129,136,144,148,154,165,180,198,255}, //color_1 = PCB_LED_PIN_1 (blue)
// {108,111,116,124,134,142,154,165,185,224},  //color_2 = PCB_LED_PIN_3 (green)
// {253,248,235,202,170,140,100,80,40,0}};     //matrix


  return bright_index[rgbled_matrix_nr][dim_level];
}



void _bright_level (uint8_t level)
{
  
  rgb_dim_level[0]= _bright_level_index(0,level) ; //color_1 = PCB_LED_PIN_1
  rgb_dim_level[1]= _bright_level_index(1,level) ; //color_2 = PCB_LED_PIN_3
  rgb_dim_level[2]= _bright_level_index(2,level) ; //color_3 = PCB_LED_PIN_4
  OCR2B           = _bright_level_index(3,level) ; //matrix
  
}



void _LED_BRIGHT_LEVEL (uint8_t led_dim_pin_1, uint8_t led_dim_pin_3, uint8_t led_dim_pin_4)
{
  
  uint8_t high_byte = 0;
  
  
  high_byte = 0b01110000;
  high_byte |= (led_dim_pin_4 >> 4);
  
  _MPC(1,high_byte, (led_dim_pin_4 <<4 )); //PIN_4 0b0111 first bits, device 1
  
  
  high_byte = 0b01110000;
  high_byte |= (led_dim_pin_3 >> 4);
  
  _MPC(0,high_byte, (led_dim_pin_3 << 4)); //PIN_3 0b0111 first bits, device 0
  
  
  high_byte = 0b11110000;
  high_byte |= (led_dim_pin_1 >> 4);
  _MPC(0,high_byte, (led_dim_pin_1 << 4)); //PIN_1 0b1111 first bits, device 0
  
}



void  _ONE_RGB_BRIGHT(uint8_t led_dim_pin, uint8_t bright_level)
{
    
    uint16_t address=0b0111000000000000;
    uint8_t level; 
    
    level= _bright_level_index(led_dim_pin,bright_level);
    address |= (uint16_t) (level << 4);
    
    switch(led_dim_pin)
    {
        //PCB RGB LED PIN
        //PIN_1 = color_1
        //PIN_2 = GND
        //PIN_3 = color_2
        //PIN_4 = color_3 
        
        case 0: 
            address |= (1<<15); 
            _MPC(0,(address>>8),address); //PIN_1= color_1
            break;
            
        case 1:
            _MPC(0,(address>>8),address); //PIN_3= color_2
            break;
            
        case 2:
            _MPC(1,(address>>8),address); //PIN_4= color_3
            break;
            
        case 3:
            OCR2B  = level ;
            break;
    } 
}



void _MATRIX_CLEAR(void)
{
  uint8_t count=0;
  
  for (;count <  14;count++)
  {
    matrix[count]= 0; 
  }
}



void _LED_CLEAR(void)
{
  uint8_t count=0;
  
  for (;count <  12;count++)
  {
    rgb_led[count]= 0;
  }
}



void _12LED_SET (uint8_t led_nr,uint8_t rgb_colour,uint8_t set)
{  
  if (set < 1)
  {
    // set led colour
    rgb_led[led_nr]   |=  (1 << rgb_colour);
    
  }else{
    
    // clear led colour
    rgb_led[led_nr]   &= ~(1 << rgb_colour);
  } 
}



void ziffer_load(uint8_t ziffer_nr,uint8_t shift_right_nr,uint8_t show)
{
  uint16_t address = ADDRESS_DIGITS_BIG;
  uint8_t  row=0;
  
  uint16_t upper_row = 0;
  uint16_t under_row = 0;
  
  uint16_t upper_row_shift = 0;
  uint16_t under_row_shift = 0;
  
  
  address= address+(ziffer_nr*4);
  for (row=0;row < 7 ;row +=2)
  {
    
    //einlesen der ziffern 
    
    if (show > 0)
    {
      upper_row  = (uint16_t) _eeprom_atmega328_Read_data(address);
      
    }else{
      upper_row=0;
    }
    
    under_row = upper_row;
    // 
    upper_row = (upper_row << 8);
    upper_row &= ~(0b0000000000001111 << 8);
    
    //
    under_row = (under_row << 12);
    
    
    //verschiebe die bits rechts
    upper_row_shift = upper_row;
    upper_row = (upper_row >> shift_right_nr);
    
    under_row_shift = under_row;
    under_row = (under_row >> shift_right_nr);
    
    
    if (shift_right_nr > 14)
    {
      
      upper_row_shift = (upper_row_shift >> (shift_right_nr-15)); 
      under_row_shift = (under_row_shift >> (shift_right_nr-15));  
      
      matrix[row+7]   &=  ~(0b1111000000000000 >> (shift_right_nr-15)) ;
      matrix[row+8]   &=  ~(0b1111000000000000 >> (shift_right_nr-15)); 
      
    }else{
      
      upper_row_shift = (upper_row_shift << (15-shift_right_nr)); 
      under_row_shift = (under_row_shift << (15-shift_right_nr)); 
      
      matrix[row]     &=  ~(0b1111000000000000 >> shift_right_nr);
      
      if (row < 6){
	matrix[row+1]   &=  ~(0b1111000000000000 >> shift_right_nr); 
      }
      matrix[row+7]   &= ~(0b1111000000000000 << (15-shift_right_nr)) ;
      matrix[row+8]   &= ~(0b1111000000000000 << (15-shift_right_nr));
    }
    
    if (row > 5)
    {
      matrix[row]   |=  upper_row;
      matrix[row+7] |=  upper_row_shift;  
      
    }else{
      
      matrix[row]   |=  upper_row;
      matrix[row+1] |=  under_row;
      
      matrix[row+7] |=  upper_row_shift;
      matrix[row+8] |=  under_row_shift;
    }
    address++;
  }
}


void ziffer_load_small(uint8_t ziffer_nr,uint8_t shift_right_nr,uint8_t show)
{
  uint16_t address = ADDRESS_DIGITS_SMALL;
  uint8_t  row=0;
  uint16_t upper_row = 0;
  uint16_t under_row = 0;
  
  uint16_t upper_row_shift = 0;
  uint16_t under_row_shift = 0;
  
  
  address= address+(ziffer_nr*3);
  for (row=0;row < 6 ;row +=2)
  {
    
    //einlesen der ziffern 
    if (show > 0)
    {
      upper_row  = (uint16_t) _eeprom_atmega328_Read_data(address);
      
    }else{
      upper_row=0;
    }
    
    under_row = upper_row;
    // 
    upper_row = (upper_row << 8);
    upper_row &= ~(0b0000000000001111 << 8);
    
    //
    under_row = (under_row << 12);
    
    
    //verschiebe die bits rechts
    upper_row_shift = upper_row;
    upper_row = (upper_row >> shift_right_nr);
    
    under_row_shift = under_row;
    under_row = (under_row >> shift_right_nr);
    
    
    if (shift_right_nr > 14)
    {
      
      upper_row_shift = (upper_row_shift >> (shift_right_nr-15)); 
      under_row_shift = (under_row_shift >> (shift_right_nr-15));  
      
      matrix[row+7]   &=  ~(0b1110000000000000 >> (shift_right_nr-15)) ;
      matrix[row+8]   &=  ~(0b1110000000000000 >> (shift_right_nr-15)); 
      
    }else{
      
      upper_row_shift = (upper_row_shift << (15-shift_right_nr)); 
      under_row_shift = (under_row_shift << (15-shift_right_nr)); 
      
      matrix[row]     &=  ~(0b1110000000000000 >> shift_right_nr);
      matrix[row+1]   &=  ~(0b1110000000000000 >> shift_right_nr); 
      
      matrix[row+7]   &= ~(0b1110000000000000 << (15-shift_right_nr)) ;
      matrix[row+8]   &= ~(0b1110000000000000 << (15-shift_right_nr));
    }
    
    
    
    matrix[row]   |=  upper_row;
    matrix[row+1] |=  under_row;
    
    matrix[row+7] |=  upper_row_shift;
    matrix[row+8] |=  under_row_shift;
    
    address++;
  }
  
  
}



void _alphabet_load(uint8_t alphabet_nr,uint8_t shift_right_nr,uint8_t show)
{
  
  uint16_t address = ADDRESS_DIGITS_ABC;
  uint8_t  row=0;
  
  uint16_t upper_row = 0;
  uint16_t upper_row_shift = 0;
  
  
  address= address+(alphabet_nr * 7);
  for (row=0;row < 7 ;row ++)
  {
    
    //einlesen der ziffern  
    if (show > 0)
    {
      upper_row  = (uint16_t) _eeprom_atmega328_Read_data(address);
      
    }else{
      upper_row=0;
    }
    
    // 
    upper_row = (upper_row << 8);
    
    //verschiebe die bits rechts
    upper_row_shift = upper_row;
    upper_row = (upper_row >> shift_right_nr);
    
    
    if (shift_right_nr > 14)
    {
      
      upper_row_shift = (upper_row_shift >> (shift_right_nr-15));   
      matrix[row+7]   &=  ~(0b1111100000000000 >> (shift_right_nr-15)) ;
      
      
    }else{
      
      upper_row_shift = (upper_row_shift << (15-shift_right_nr)); 
      
      
      matrix[row]     &=  ~(0b1111100000000000 >> shift_right_nr);  
      matrix[row+7]   &=  ~(0b1111100000000000 << (15-shift_right_nr)) ;
      
    }
    
    matrix[row]   |=  upper_row;  
    matrix[row+7] |=  upper_row_shift;
    
    address++;
  }
  
}



void _dot(uint8_t colum_nr)
{
  
  if (colum_nr > 14)
  {
    if (!(t_sec%2)) 
    { 
      matrix[8]  |= (1 <<  (30-colum_nr)); 
      matrix[12] |= (1 <<  (30-colum_nr));   
    }else{ 
      matrix[8]  &= ~(1 <<  (30-colum_nr)); 
      matrix[12] &= ~(1 <<  (30-colum_nr));
    }                 
  }else{ 
    
    if (!(t_sec%2)) 
    {
      matrix[1] |= (1 <<  (15-colum_nr)); 
      matrix[5] |= (1 <<  (15-colum_nr));   
    }else{ 
      matrix[1] &= ~(1 <<  (15-colum_nr)); 
      matrix[5] &= ~(1 <<  (15-colum_nr));  
    }
  }
}



void _set_LED_Ring(uint8_t mod)
{
    //set led _show_led_ring
    uint8_t clear_std=0;
    uint8_t clear_min=0;
    uint8_t clear_sec=0;
    
    uint8_t dummy_rgb_led=0;
    int8_t count=0x0;
    
    led_sec = 11-t_sec/5;
    led_min = 11-t_min/5;
    
    if (t_std > 11) {led_std = 11 - (t_std-12);}else{ led_std = 11- t_std;}
    
    switch (mod)
    {
        case 0: 
            
            clear_sec = led_sec+1;
            clear_min = led_min+1;
            clear_std = led_std+1;
            if (clear_sec > 11){clear_sec = 0;   } 
            if (clear_min > 11){clear_min = 0;   } 
            if (clear_std > 11){clear_std = 0;   } 
            
            _12LED_SET (clear_sec,COLOR_SEC,1) ;
            _12LED_SET (clear_min,COLOR_MIN,1) ;
            _12LED_SET (clear_std,COLOR_STD,1) ;
            
            _12LED_SET (led_sec,COLOR_SEC,0) ;
            _12LED_SET (led_min,COLOR_MIN,0) ;
            _12LED_SET (led_std,COLOR_STD,0) ;
            
            break;
            
        case 1:
            
            if (led_std < led_min)
            {
                for (count=11;count >= 0;count--)
                {
                    if (led_sec == count){ _12LED_SET (count,COLOR_SEC,0) ;_12LED_SET (count,COLOR_MIN,1);_12LED_SET (count,COLOR_STD,1);   }else
                    {
                        _12LED_SET (count,COLOR_SEC,1) ;
                        if (led_min <= count){ _12LED_SET (count,COLOR_MIN,0) ;}else{_12LED_SET (count,COLOR_MIN,1);}
                        if (led_min > count && led_std <=count){ _12LED_SET (count,COLOR_STD,0) ;}else{_12LED_SET (count,COLOR_STD,1)    ;}
                    }
                }
            }else{
                for (count=11;count >= 0;count--)
                {
                    if (led_sec == count){ _12LED_SET (count,COLOR_SEC,0) ;_12LED_SET (count,COLOR_MIN,1);_12LED_SET (count,COLOR_STD,1);}else
                    {
                        _12LED_SET (count,COLOR_SEC,1) ;
                        if (led_std <= count){ _12LED_SET (count,COLOR_STD,0) ;}else{_12LED_SET (count,COLOR_STD,1);}
                        if (led_std > count && led_min <=count){ _12LED_SET (count,COLOR_MIN,0) ;}else{_12LED_SET (count,COLOR_MIN,1)    ;}
                    }
                    
                }
            }
            if ((led_std == led_min) && (led_min != led_sec)) {   _12LED_SET (led_min,COLOR_MIN,0) ; }
            break;
            
            
        case 2: 
            for (count=11;count >= 0;count--)
            {
                dummy_rgb_led =0b00000000 ;
                if (led_min <= count){ dummy_rgb_led |= (1 << COLOR_MIN) ;}//0 = colour green
                if (led_std <= count){ dummy_rgb_led |= (1 << COLOR_STD) ;}//2 = colour blue
                
                
                //sec --------------------------------------------------------------  
                if (led_sec <= count)
                { 
                    
                    if ((dummy_rgb_led == (1 << COLOR_STD)) || (dummy_rgb_led == (1 << COLOR_MIN)) || (dummy_rgb_led == 0b00000000))
                    {
                        dummy_rgb_led |= (1 << COLOR_SEC);
                        
                    }else{
                        
                        if ( (led_sec == count ))
                        {
                            dummy_rgb_led = (1 << COLOR_SEC);  
                        }
                    }   
                    
                    
                }else{
                    
                    _12LED_SET (count,COLOR_SEC,1);
                }
                //--------------------------------------------------------------- 
                
                if ( ((led_std == count) && (led_min == count)) &&  ( led_sec != count)     )
                {   
                    if (!(t_sec%2))
                    {
                        dummy_rgb_led = ((1 << COLOR_SEC) | (1 << COLOR_STD)) ;
                    
                        
                    }else{ 
                        
                        dummy_rgb_led  =0b00000000;
                    }
                }
                
                rgb_led[count]=dummy_rgb_led;   
            }
            break;
    }   
}





void _show_time(void)
{
  uint8_t ziffer_pos_start=0;
  uint8_t show=1;
  
  //-------------------------------------------------------------------------------------------
  // 12/24=on , second show=off, alarm standby=off ,when 12 hour modus show am or pm symbol and place the time righthand
  if (   status_byte_clock&(1<<5)  && !(status_byte_clock&(1<<2)) && !(alarm_status&(1<<0)) )  
  {
    ziffer_pos_start=9;
    
    //pointer 12/24 mod  show am/pm
    if (status_byte_time&(1<<2)){
      if (t_std > 11 && (status_byte_clock&(1<<5)) ) 
      {
	//display am symbol
	matrix[3] =0b1110111110000000;
	matrix[4] =0b1010101010000000;
	matrix[5] =0b1110101010000000;
	matrix[6] =0b1000101010000000;
	
      }else{
	//display pm symbol
	matrix[3] =0b1110111110000000;
	matrix[4] =0b1010101010000000;
	matrix[5] =0b1110101010000000;
	matrix[6] =0b1010101010000000;
      }
    }
  }
  
  // 12/24=off, second show=off, alarm off, when 24 modus place the time in the middle
  if ( !(status_byte_clock&(1<<5)) && !(status_byte_clock&(1<<2)) & !(alarm_status&(1<<0)) )
  {
    ziffer_pos_start=4;      
  }
  // whe the alarm is on standby or the seconds on, the time will be placed on the lefthand
  //-------------------------------------------------------------------------------------------
  
  //Show time on the display matrix------------------------------------------------------------
  //Show std , 12 or 24 mod  
  if (status_byte_time&(1<<2)){
    if (status_byte_clock&(1<<5))
    {
      hour12std =((t_std+11)%12)+1;
      
      if ( (hour12std/10) < 1) {show=0;}
      
      ziffer_load( hour12std /10,  ziffer_pos_start   ,show);
      ziffer_load( hour12std %10,  ziffer_pos_start+5 ,1);
      
    }else{
      
      if ( (t_std/10) < 1) {show=0;}
      ziffer_load(t_std/10, ziffer_pos_start   ,show);
      ziffer_load(t_std%10, ziffer_pos_start+5 ,1); 
    }
    
    status_byte_time &=~(1<<2); 
  }
  
  
  //show min
  if (status_byte_time&(1<<1))
  {
    ziffer_load(t_min/10, ziffer_pos_start+12 ,1);
    ziffer_load(t_min%10, ziffer_pos_start+17 ,1);
    
    status_byte_time &=~(1<<1);
  }
  
  //show sec ,when second = on and the alarm standby is off
  if (status_byte_clock&(1 << 2) && !(alarm_status&(1<<0)))
  {   
    ziffer_load_small(t_sec / 10,  23,1);
    ziffer_load_small(t_sec % 10,  27,1);
    
    //dot are not blinking
    matrix[1] |= (1 << 5); 
    matrix[5] |= (1 << 5); 
    
  }
  
  //show 12/24 pointer when 12std modus on and the second on or alarm standby on
  if ((status_byte_clock&(1 << 2) || alarm_status&(1<<0)) && status_byte_clock&(1<<5) )
  {
    //pointer
    if (t_std > 11 ) 
    {
      matrix[6] |= (1 << 15);//pointer show
    }else{
      
      matrix[6] &= ~(1 << 15);//pointer disapear
    } 
  }
  
  // show blinking dots,when the seconds are off or the  alarm is set
  if ( !(status_byte_clock&(1 << 2) ) ||  alarm_status &(1<<0))
  {
    _dot(ziffer_pos_start+10);
  }  
}



void _show_led_ring(uint8_t modus_time_alarm)
{
  
  switch(modus_time_alarm)
  {
    case 0: 
      
      _set_LED_Ring(ring_set);
      break;
      
    case 1:  
      //show alarm wake up time 
      
      if ( !(alarm_status&(1<<1))   ){
	led_min = 11-alarm_min[alarm_nr]/5;
	
	if (alarm_std[alarm_nr] > 11) {led_std = 11 - (alarm_std[alarm_nr]-12);}else{ led_std = 11- alarm_std[alarm_nr];}
	
	
	_12LED_SET (led_min,COLOR_MIN,0) ;
	_12LED_SET (led_std,COLOR_STD,0) ;
      }
      break;
      
      
    case 2:
      //show final alarm time 
      led_min = 11-final_alarm_min /5;
      
      if (final_alarm_std > 11) {led_std = 11 - (final_alarm_std-12);}else{ led_std = 11- final_alarm_std;}
      
      
      _12LED_SET (led_min,COLOR_MIN,0) ;
      _12LED_SET (led_std,COLOR_STD,0) ;
      break;
  }
  
}



void _show_alarmstatus(void)
{
  if(screen == 1)
  {
    ziffer_load(10, 0  ,1);
    ziffer_load(alarm_nr+11,4,1);
    
    if ( alarm_status &(1<<0) )
    {
      matrix[0] |=0b1110000000000000;  
    }else{
      matrix[0] &=~0b1110000000000000;
    }
    
    
  }
  
  if(screen == 2 || screen == 3)
  {
    if ( alarm_status &(1<<0) )
    {
      ziffer_load(10, 23  ,1);
      ziffer_load(alarm_nr+11,27,1);
      matrix[7] |=0b0000000011100000;
    }
  }
}


void _show_alarm_time(uint8_t alarm_nr)
{
  uint8_t show=1;
  
  // 12 or 24 mod  
  if (status_byte_clock&(1<<5))
  {
    hour12std =((alarm_std[alarm_nr]+11)%12)+1;
    
    if ( (hour12std/10) < 1) {show=0;}
    
    ziffer_load( hour12std /10,  9 ,show);
    ziffer_load( hour12std %10,  14 ,1);
    
  }else{
    
    if ( (alarm_std[alarm_nr]/10) < 1) {show=0;}
    ziffer_load(alarm_std[alarm_nr]/10,  9 ,show);
    ziffer_load(alarm_std[alarm_nr]%10,  14 ,1);
    
  }
  
  ziffer_load(alarm_min[alarm_nr]/10,  21 ,1);
  ziffer_load(alarm_min[alarm_nr]%10,  26 ,1);
  
  //pointer 12/24 mod
  if (status_byte_clock&(1<<5))
  {
    if((alarm_std[alarm_nr]) > 11){matrix[6] |= (1 << 6);}else{matrix[6] &= ~(1 << 6);}
  }
  
  //point dot
  matrix[8]  |= (1 << 11);
  matrix[12] |= (1 << 11);
}

void _alarm_time_change(void)
{
  
  TIMEOUT= 40;    		// set TIMEOUT
  status_byte_clock |= (1<<7);		// start TIMEOUT 
  _delay_ms(150);
  status_button=0;			//all buttons reset
  _MATRIX_CLEAR();
  ziffer_load(10, 0  ,1);
  
  while ( TIMEOUT )
  {    
    _beep();
    ziffer_load(alarm_nr+11,4,1);
    _show_alarm_time(alarm_nr);
    
    TIMEOUT=30;
    
    while ( (!(status_button &(1<<3))) && TIMEOUT  );   
    _delay_ms(180);
    status_button=0;
    
    if (TIMEOUT > 0){alarm_nr++;}
    if (alarm_nr > 6 ){alarm_nr=0;}  
    
  }  
  _MATRIX_CLEAR();
  
}

void _alarm_glow(void)
{
  static uint8_t muster=0;
  uint16_t colour[3]={0,0,0};
  static uint8_t  count_leds=0;
  
  
  uint8_t trigger_alarm_std=0;
  uint8_t trigger_alarm_min=0;
  
  trigger_alarm_std = alarm_std[alarm_nr];
  trigger_alarm_min = alarm_min[alarm_nr]+5;
  
  if ( alarm_min[alarm_nr] > 54) { trigger_alarm_std +=1; }
  
  
  if (trigger_alarm_std < 1)
  {trigger_alarm_std=23;}else{trigger_alarm_std -=1;} 
  
  if (trigger_alarm_min > 59) {trigger_alarm_min = 4;} 
  
  //calculate startpoint and set alarm_status (1<<7)and make the display bright ------
  if ( (trigger_alarm_std   == t_std) && (trigger_alarm_min <= t_min) )
  {
    alarm_status |= (1<<7);          //set the dots evry 5 minuts 
    _LED_BRIGHT_LEVEL (255,255,255); //RGB maximum bright
    if ( status_byte_time  &(1<<4) ) {OCR2B  = 0 ;}                     //matrix maximum bright
  }
  
  
  if ( (alarm_std[alarm_nr] == t_std) && (alarm_min[alarm_nr] > t_min) )
  {
    alarm_status |= (1<<7);	     //set the dots evry 5 minuts 
    _LED_BRIGHT_LEVEL (255,255,255); //RGB maximum bright
    if ( status_byte_time  &(1<<4) ) {OCR2B  = 0 ;}                     //matrix maximum bright
  }
  // --------------------------------------------------------------------------------
  
  
  // the alarm start, let the rgb ring blink ----------------------------------------
  if (alarm_status&(1 << 6)) // the alarm start glow blink is set, let the rgb ring blink
  {  
    switch(muster)// pattern select
    {
      case 0: colour[0]=0b0000101010101010; colour[1]=0b0000010101010101; colour[2]=0b0000000000000000; 
      break;
      case 1: colour[0]=0b0000000000000000; colour[1]=0b0000101010101010; colour[2]=0b0000010101010101; 
      break;
      case 2: colour[0]=0b0000000000000000; colour[1]=0b0000001100110011; colour[2]=0b0000110011001100;  
      break;
      case 3: colour[0]=0b0000000000000000; colour[1]=0b0000110011001100; colour[2]=0b0000001100110011;  
      break;
      case 4: colour[0]=0b0000000000000000; colour[1]=0b0000111000111000; colour[2]=0b0000000111000111; 
      break;
      case 5: colour[0]=0b0000000000000000; colour[1]=0b0000000111000111; colour[2]=0b0000111000111000; 
      break;
      case 6: colour[0]=0b0001010101010101; colour[1]=0b0000101010101010; colour[2]=0b0000000000000000;  
      break;
      case 7: colour[0]=0b0000101010101010; colour[1]=0b0000000000000000; colour[2]=0b0000010101010101;
      break;
    }
    
    for (count_leds=0;count_leds < 12;count_leds++)
    {
      
      if ( colour[0]&(1<<count_leds) ){ _12LED_SET (count_leds,COLOR_MIN,0) ;}else{ _12LED_SET (count_leds,COLOR_MIN,1) ;}
      if ( colour[1]&(1<<count_leds) ){ _12LED_SET (count_leds,COLOR_SEC,0) ;}else{ _12LED_SET (count_leds,COLOR_SEC,1) ;}
      if ( colour[2]&(1<<count_leds) ){ _12LED_SET (count_leds,COLOR_STD,0) ;}else{ _12LED_SET (count_leds,COLOR_STD,1) ;}
    } 
    muster++; if (muster>7){muster=0;}
  
  }
  // the alarm start, let the rgb ring blink END -------------------------------------
  
  
  // Set the dots every 5 minuts ------------------------------------------------------
  if ( alarm_status&(1 << 7) &&  !(alarm_status&(1<<6)) && !(alarm_status&(1 << 3)))
  {       
    led_min = 11-t_min/5;
    //_12LED_SET (led_min,COLOR_MIN,0) ;  
    
    _12LED_SET (led_min,COLOR_SEC,0) ;    
    
    //_12LED_SET (led_min,COLOR_STD,0) ;
  }   
  // Set the dots evry 5 minuts END --------------------------------------------------
}





