//RGB Colour Clock Driver alpha 1.1

//Written by Christoph Kreis
//You can change the code if you like or share it with your friends, but it's not allowed to deal with the code.




void _i2c_init(void)
{
  // I2C Konfigurieren ----------------------------
  int SCL=5;// Port PC5  Clock (Takt)
  int SDA=4;// Port PC4  Data  (Datenleitung)
  
  // Pull-Up Widerstände von SCL und SDA setzen
  //DDRC &= ~((1<<SCL) | (1<<SDA));
  //PORTC |= (1<<SCL) | (1<<SDA);
  
  //Pull-Up Ausschalten
  
  DDRC &= ~((1<<SCL) | (1<<SDA));
  PORTC &= ~((1<<SCL) | (1<<SDA));
  
  // benötigten Wert zur Datenratenerzeugung in das TWBR schreiben
  //TWBR = 52; // wert 52 erzeugt einen wert von 100KHZ bei einem CPU Takt von 12MHZ ->siehe datenblatt
  //TWBR = 7; // wert 7 erzeugt einen wert von 400KHZ bei einem CPU Takt von 12MHZ ->siehe datenblatt
  // TWBR = 12; // wert 12 erzeugt einen wert von 400KHZ bei einem CPU Takt von 16MHZ ->siehe datenblatt
  // TWBR = 72; // wert 72 erzeugt einen wert von 100KHZ bei einem CPU Takt von 16MHZ ->siehe datenblatt
  
}



void _RTC_DS1307_Read_Write_init (uint8_t Adresse,uint8_t Read_Write)//Read_Write  Read = 1 , Write = 0
{
  cli();
  uint8_t while_break;
  while_break=0;
  
  TWBR = 72; // wert 72 erzeugt einen wert von 100KHZ bei einem CPU Takt von 16MHZ ->siehe datenblatt
  
  TWCR = (1<<TWINT) | (1<<TWSTA)| (1<<TWEN);//Start I2C Bus ,(1<<TWINT) durch setzen 1 wird das TWINT bit gelöscht,(1<<TWSTA) Startbit wird gesetzt ,(1<<TWEN) TWI (I2C)  wird aktiviert
  
  
  while (!(TWCR & (1<<TWINT))){ while_break++;if (while_break>254){break;} }// Warte Bis der obige Befehl ausgeführt wurde 
  while_break=0;
  
  
  TWDR = ( 0b01101000 <<1)| TW_WRITE;// Chip Adresse 0b1101000 für RTC DS1307
  TWCR = (1<<TWINT) | (1 << TWEN);
  while (!(TWCR & (1<<TWINT))){ while_break++;if (while_break>254){break;} }
  while_break=0;  
  if ((TWSR & 0xF8) !=  TW_MT_SLA_ACK){ status_byte_clock |=(1 << 3);}// RTC_DS1307 Error (not connected) 
  
  // sende  Adresse 
  TWDR = (Adresse);
  TWCR = (1<<TWINT) | (1 << TWEN);
  while (!(TWCR & (1<<TWINT))){ while_break++;if (while_break>254){break;} }
  while_break=0;
  
  if (Read_Write > 0) // Read_Write = 1 then Read
  {
    TWCR = (1<<TWINT) | (1<<TWSTA)| (1<<TWEN);//re start
    while (!(TWCR & (1<<TWINT))){ while_break++;if (while_break>254){break;} }
    while_break=0;
    
    TWDR = ( 0b01101000 <<1)| TW_READ;// Chip Adresse 0b1101000 für RTC DS1307
    TWCR = (1<<TWINT) | (1 << TWEN);
    while (!(TWCR & (1<<TWINT))){ while_break++;if (while_break>254){break;} }
    while_break=0;
    
  } 
  sei();
  
}



//Daten schreiben RTC_DS1307

void _I2C_Write_data (uint8_t daten_char,uint8_t stop) // daten 8bit lang, stop = 1 beendet transfer
{
  cli();
  uint8_t while_break;
  while_break=0;
  
  //sende Daten
  TWDR = (daten_char); 
  TWCR = (1<<TWINT) | (1 << TWEN);
  while (!(TWCR & (1<<TWINT))){ while_break++;if (while_break>254){break;} }// Warte Bis der obige Befehl ausgeführt wurde 
  while_break=0;
  
  if (stop > 0) {
    TWCR = (1<<TWINT) | (1<<TWSTO) | (1<<TWEN); //I2C Stop
  }
  sei();
  
}


//Daten lesen für RTC_DS1307

uint8_t _I2C_Read_data (uint8_t stop)// stop = 1 es wird nur ein daten satz gelesen und bus verbindung wird beendet   
{   
  cli();
  uint8_t while_break;
  uint8_t daten_char;
  while_break=0;
  
  TWCR = (1<<TWINT) | (1 << TWEN) | (1<<TWEA) ; // Daten auslesen und nach dem Auslesn mit Ack bestättigen (1<<TWEA) 
  while (!(TWCR & (1<<TWINT))){ while_break++;if (while_break>254){break;} }// Warte Bis der obige Befehl ausgeführt wurde 
  while_break=0;
  
  daten_char = TWDR;                         
  
  if (stop > 0) {
    TWCR = (1<<TWINT) | (1 << TWEN);                // NACK wird gesendet
    while (!(TWCR & (1<<TWINT))){ while_break++;if (while_break>254){break;} }
    while_break=0;
    
    TWCR = (1<<TWINT) | (1<<TWSTO) | (1<<TWEN); //I2C Stop
  }
  sei();
  return daten_char;  
}



uint8_t _BCD2Digit_to_Binary(uint8_t BCD_2Digit)
{
  cli();
  uint8_t Digit=0b00000000;
  
  Digit=BCD_2Digit;
  BCD_2Digit &= ~0b11110000;// lösche die ersten 4 bits
  Digit= ((Digit>>4)*10)+BCD_2Digit;
  return Digit;
  
  sei();
}

uint8_t _Binary_to_BCD2Digit(uint8_t Byte)
{
  uint8_t Digit=0b00000000;
  
  Digit  = Byte%10;
  Byte   = Byte/10;
  Digit |= (Byte << 4);
  
  return Digit;
  
}


uint8_t _load_RTC_Binary(uint8_t stop)
{
  cli();
  uint8_t value=0;
  
  BCD_2Digit =_I2C_Read_data (0);//load value BCD Format 
  value =_BCD2Digit_to_Binary(BCD_2Digit);
  
  sei();
  return value; //return binary Format
  
}

void _RTC_write_alarmstatus(void)
{
  
  if (!(status_byte_clock &(1<<3)))// RTC write  "status_byte_clock &(1<<3) is 0" then write 
  {
    _RTC_DS1307_Read_Write_init (0x16,0);	// Read = 1 , Write = 0 
    _I2C_Write_data (alarm_nr    ,0);		// write alarm nr. 
    _I2C_Write_data (alarm_status,1);		// write alarm alarm_status 
  }
  
}




